@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.kotlin.outputs.TransitRouterVpcAttachmentZoneMapping
import com.pulumi.alicloud.cen.kotlin.outputs.TransitRouterVpcAttachmentZoneMapping.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [TransitRouterVpcAttachment].
 */
@PulumiTagMarker
public class TransitRouterVpcAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitRouterVpcAttachmentArgs = TransitRouterVpcAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitRouterVpcAttachmentArgsBuilder.() -> Unit) {
        val builder = TransitRouterVpcAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TransitRouterVpcAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.cen.TransitRouterVpcAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitRouterVpcAttachment(builtJavaResource)
    }
}

/**
 * Provides a CEN Transit Router VPC Attachment resource that associate the VPC with the CEN instance. [What is Cen Transit Router VPC Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpcattachment)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.cen.getTransitRouterAvailableResources({});
 * const masterZone = _default.then(_default => _default.resources?.[0]?&#46;masterZones?&#46;[0]);
 * const slaveZone = _default.then(_default => _default.resources?.[0]?&#46;slaveZones?&#46;[1]);
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const exampleMaster = new alicloud.vpc.Switch("example_master", {
 *     vswitchName: name,
 *     cidrBlock: "192.168.1.0/24",
 *     vpcId: example.id,
 *     zoneId: masterZone,
 * });
 * const exampleSlave = new alicloud.vpc.Switch("example_slave", {
 *     vswitchName: name,
 *     cidrBlock: "192.168.2.0/24",
 *     vpcId: example.id,
 *     zoneId: slaveZone,
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: name,
 *     cenId: exampleInstance.id,
 * });
 * const exampleTransitRouterVpcAttachment = new alicloud.cen.TransitRouterVpcAttachment("example", {
 *     cenId: exampleInstance.id,
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     vpcId: example.id,
 *     zoneMappings: [
 *         {
 *             zoneId: masterZone,
 *             vswitchId: exampleMaster.id,
 *         },
 *         {
 *             zoneId: slaveZone,
 *             vswitchId: exampleSlave.id,
 *         },
 *     ],
 *     transitRouterAttachmentName: name,
 *     transitRouterAttachmentDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cen.get_transit_router_available_resources()
 * master_zone = default.resources[0]&#46;master_zones[0]
 * slave_zone = default.resources[0]&#46;slave_zones[1]
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * example_master = alicloud.vpc.Switch("example_master",
 *     vswitch_name=name,
 *     cidr_block="192.168.1.0/24",
 *     vpc_id=example.id,
 *     zone_id=master_zone)
 * example_slave = alicloud.vpc.Switch("example_slave",
 *     vswitch_name=name,
 *     cidr_block="192.168.2.0/24",
 *     vpc_id=example.id,
 *     zone_id=slave_zone)
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name=name,
 *     cen_id=example_instance.id)
 * example_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("example",
 *     cen_id=example_instance.id,
 *     transit_router_id=example_transit_router.transit_router_id,
 *     vpc_id=example.id,
 *     zone_mappings=[
 *         {
 *             "zone_id": master_zone,
 *             "vswitch_id": example_master.id,
 *         },
 *         {
 *             "zone_id": slave_zone,
 *             "vswitch_id": example_slave.id,
 *         },
 *     ],
 *     transit_router_attachment_name=name,
 *     transit_router_attachment_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
 *     var masterZone = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;MasterZones[0]));
 *     var slaveZone = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;SlaveZones[1]));
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var exampleMaster = new AliCloud.Vpc.Switch("example_master", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "192.168.1.0/24",
 *         VpcId = example.Id,
 *         ZoneId = masterZone,
 *     });
 *     var exampleSlave = new AliCloud.Vpc.Switch("example_slave", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "192.168.2.0/24",
 *         VpcId = example.Id,
 *         ZoneId = slaveZone,
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = name,
 *         CenId = exampleInstance.Id,
 *     });
 *     var exampleTransitRouterVpcAttachment = new AliCloud.Cen.TransitRouterVpcAttachment("example", new()
 *     {
 *         CenId = exampleInstance.Id,
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         VpcId = example.Id,
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
 *             {
 *                 ZoneId = masterZone,
 *                 VswitchId = exampleMaster.Id,
 *             },
 *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
 *             {
 *                 ZoneId = slaveZone,
 *                 VswitchId = exampleSlave.Id,
 *             },
 *         },
 *         TransitRouterAttachmentName = name,
 *         TransitRouterAttachmentDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		masterZone := _default.Resources[0]&#46;MasterZones[0]
 * 		slaveZone := _default.Resources[0]&#46;SlaveZones[1]
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleMaster, err := vpc.NewSwitch(ctx, "example_master", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.1.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(masterZone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSlave, err := vpc.NewSwitch(ctx, "example_slave", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(slaveZone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String(name),
 * 			CenId:             exampleInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterVpcAttachment(ctx, "example", &cen.TransitRouterVpcAttachmentArgs{
 * 			CenId:           exampleInstance.ID(),
 * 			TransitRouterId: exampleTransitRouter.TransitRouterId,
 * 			VpcId:           example.ID(),
 * 			ZoneMappings: cen.TransitRouterVpcAttachmentZoneMappingArray{
 * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
 * 					ZoneId:    pulumi.String(masterZone),
 * 					VswitchId: exampleMaster.ID(),
 * 				},
 * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
 * 					ZoneId:    pulumi.String(slaveZone),
 * 					VswitchId: exampleSlave.ID(),
 * 				},
 * 			},
 * 			TransitRouterAttachmentName:        pulumi.String(name),
 * 			TransitRouterAttachmentDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.CenFunctions;
 * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVpcAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs;
 * import com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = CenFunctions.getTransitRouterAvailableResources();
 *         final var masterZone = default_.resources()[0]&#46;masterZones()[0];
 *         final var slaveZone = default_.resources()[0]&#46;slaveZones()[1];
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var exampleMaster = new Switch("exampleMaster", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("192.168.1.0/24")
 *             .vpcId(example.id())
 *             .zoneId(masterZone)
 *             .build());
 *         var exampleSlave = new Switch("exampleSlave", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .vpcId(example.id())
 *             .zoneId(slaveZone)
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName(name)
 *             .cenId(exampleInstance.id())
 *             .build());
 *         var exampleTransitRouterVpcAttachment = new TransitRouterVpcAttachment("exampleTransitRouterVpcAttachment", TransitRouterVpcAttachmentArgs.builder()
 *             .cenId(exampleInstance.id())
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .vpcId(example.id())
 *             .zoneMappings(
 *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
 *                     .zoneId(masterZone)
 *                     .vswitchId(exampleMaster.id())
 *                     .build(),
 *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
 *                     .zoneId(slaveZone)
 *                     .vswitchId(exampleSlave.id())
 *                     .build())
 *             .transitRouterAttachmentName(name)
 *             .transitRouterAttachmentDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   exampleMaster:
 *     type: alicloud:vpc:Switch
 *     name: example_master
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 192.168.1.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${masterZone}
 *   exampleSlave:
 *     type: alicloud:vpc:Switch
 *     name: example_slave
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${slaveZone}
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: ${name}
 *       cenId: ${exampleInstance.id}
 *   exampleTransitRouterVpcAttachment:
 *     type: alicloud:cen:TransitRouterVpcAttachment
 *     name: example
 *     properties:
 *       cenId: ${exampleInstance.id}
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       vpcId: ${example.id}
 *       zoneMappings:
 *         - zoneId: ${masterZone}
 *           vswitchId: ${exampleMaster.id}
 *         - zoneId: ${slaveZone}
 *           vswitchId: ${exampleSlave.id}
 *       transitRouterAttachmentName: ${name}
 *       transitRouterAttachmentDescription: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cen:getTransitRouterAvailableResources
 *       Arguments: {}
 *   masterZone: ${default.resources[0]&#46;masterZones[0]}
 *   slaveZone: ${default.resources[0]&#46;slaveZones[1]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Transit Router VPC Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment example <cen_id>:<transit_router_attachment_id>
 * ```
 */
public class TransitRouterVpcAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.cen.TransitRouterVpcAttachment,
) : KotlinCustomResource(javaResource, TransitRouterVpcAttachmentMapper) {
    /**
     * Whether the transit router is automatically published to the VPC instance. Default value: `false`. Valid values:
     */
    public val autoPublishRouteEnabled: Output<Boolean>?
        get() = javaResource.autoPublishRouteEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the CEN.
     */
    public val cenId: Output<String>
        get() = javaResource.cenId().applyValue({ args0 -> args0 })

    /**
     * The dry run.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payment type of the resource. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
     */
    @Deprecated(
        message = """
  Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead.
  """,
    )
    public val routeTableAssociationEnabled: Output<Boolean>?
        get() = javaResource.routeTableAssociationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
     */
    @Deprecated(
        message = """
  Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead.
  """,
    )
    public val routeTablePropagationEnabled: Output<Boolean>?
        get() = javaResource.routeTablePropagationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The associating status of the network.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The description of the transit router vbr attachment.
     */
    public val transitRouterAttachmentDescription: Output<String>?
        get() = javaResource.transitRouterAttachmentDescription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The ID of the Transit Router Attachment.
     */
    public val transitRouterAttachmentId: Output<String>
        get() = javaResource.transitRouterAttachmentId().applyValue({ args0 -> args0 })

    /**
     * The name of the transit router vbr attachment.
     */
    public val transitRouterAttachmentName: Output<String>?
        get() = javaResource.transitRouterAttachmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the transit router.
     */
    public val transitRouterId: Output<String>
        get() = javaResource.transitRouterId().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The owner id of vpc.
     */
    public val vpcOwnerId: Output<String>
        get() = javaResource.vpcOwnerId().applyValue({ args0 -> args0 })

    /**
     * The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    public val zoneMappings: Output<List<TransitRouterVpcAttachmentZoneMapping>>
        get() = javaResource.zoneMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object TransitRouterVpcAttachmentMapper : ResourceMapper<TransitRouterVpcAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cen.TransitRouterVpcAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TransitRouterVpcAttachment =
        TransitRouterVpcAttachment(javaResource as com.pulumi.alicloud.cen.TransitRouterVpcAttachment)
}

/**
 * @see [TransitRouterVpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitRouterVpcAttachment].
 */
public suspend fun transitRouterVpcAttachment(
    name: String,
    block: suspend TransitRouterVpcAttachmentResourceBuilder.() -> Unit,
): TransitRouterVpcAttachment {
    val builder = TransitRouterVpcAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitRouterVpcAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitRouterVpcAttachment(name: String): TransitRouterVpcAttachment {
    val builder = TransitRouterVpcAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
