@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs.builder
import com.pulumi.alicloud.cen.kotlin.inputs.TransitRouterVpcAttachmentZoneMappingArgs
import com.pulumi.alicloud.cen.kotlin.inputs.TransitRouterVpcAttachmentZoneMappingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CEN Transit Router VPC Attachment resource that associate the VPC with the CEN instance. [What is Cen Transit Router VPC Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpcattachment)
 * > **NOTE:** Available since v1.126.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.cen.getTransitRouterAvailableResources({});
 * const masterZone = _default.then(_default => _default.resources?.[0]?&#46;masterZones?&#46;[0]);
 * const slaveZone = _default.then(_default => _default.resources?.[0]?&#46;slaveZones?&#46;[1]);
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const exampleMaster = new alicloud.vpc.Switch("example_master", {
 *     vswitchName: name,
 *     cidrBlock: "192.168.1.0/24",
 *     vpcId: example.id,
 *     zoneId: masterZone,
 * });
 * const exampleSlave = new alicloud.vpc.Switch("example_slave", {
 *     vswitchName: name,
 *     cidrBlock: "192.168.2.0/24",
 *     vpcId: example.id,
 *     zoneId: slaveZone,
 * });
 * const exampleInstance = new alicloud.cen.Instance("example", {
 *     cenInstanceName: name,
 *     protectionLevel: "REDUCED",
 * });
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     transitRouterName: name,
 *     cenId: exampleInstance.id,
 * });
 * const exampleTransitRouterVpcAttachment = new alicloud.cen.TransitRouterVpcAttachment("example", {
 *     cenId: exampleInstance.id,
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     vpcId: example.id,
 *     zoneMappings: [
 *         {
 *             zoneId: masterZone,
 *             vswitchId: exampleMaster.id,
 *         },
 *         {
 *             zoneId: slaveZone,
 *             vswitchId: exampleSlave.id,
 *         },
 *     ],
 *     transitRouterAttachmentName: name,
 *     transitRouterAttachmentDescription: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.cen.get_transit_router_available_resources()
 * master_zone = default.resources[0]&#46;master_zones[0]
 * slave_zone = default.resources[0]&#46;slave_zones[1]
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * example_master = alicloud.vpc.Switch("example_master",
 *     vswitch_name=name,
 *     cidr_block="192.168.1.0/24",
 *     vpc_id=example.id,
 *     zone_id=master_zone)
 * example_slave = alicloud.vpc.Switch("example_slave",
 *     vswitch_name=name,
 *     cidr_block="192.168.2.0/24",
 *     vpc_id=example.id,
 *     zone_id=slave_zone)
 * example_instance = alicloud.cen.Instance("example",
 *     cen_instance_name=name,
 *     protection_level="REDUCED")
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     transit_router_name=name,
 *     cen_id=example_instance.id)
 * example_transit_router_vpc_attachment = alicloud.cen.TransitRouterVpcAttachment("example",
 *     cen_id=example_instance.id,
 *     transit_router_id=example_transit_router.transit_router_id,
 *     vpc_id=example.id,
 *     zone_mappings=[
 *         {
 *             "zone_id": master_zone,
 *             "vswitch_id": example_master.id,
 *         },
 *         {
 *             "zone_id": slave_zone,
 *             "vswitch_id": example_slave.id,
 *         },
 *     ],
 *     transit_router_attachment_name=name,
 *     transit_router_attachment_description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
 *     var masterZone = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;MasterZones[0]));
 *     var slaveZone = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;SlaveZones[1]));
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var exampleMaster = new AliCloud.Vpc.Switch("example_master", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "192.168.1.0/24",
 *         VpcId = example.Id,
 *         ZoneId = masterZone,
 *     });
 *     var exampleSlave = new AliCloud.Vpc.Switch("example_slave", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "192.168.2.0/24",
 *         VpcId = example.Id,
 *         ZoneId = slaveZone,
 *     });
 *     var exampleInstance = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = name,
 *         ProtectionLevel = "REDUCED",
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         TransitRouterName = name,
 *         CenId = exampleInstance.Id,
 *     });
 *     var exampleTransitRouterVpcAttachment = new AliCloud.Cen.TransitRouterVpcAttachment("example", new()
 *     {
 *         CenId = exampleInstance.Id,
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         VpcId = example.Id,
 *         ZoneMappings = new[]
 *         {
 *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
 *             {
 *                 ZoneId = masterZone,
 *                 VswitchId = exampleMaster.Id,
 *             },
 *             new AliCloud.Cen.Inputs.TransitRouterVpcAttachmentZoneMappingArgs
 *             {
 *                 ZoneId = slaveZone,
 *                 VswitchId = exampleSlave.Id,
 *             },
 *         },
 *         TransitRouterAttachmentName = name,
 *         TransitRouterAttachmentDescription = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		masterZone := _default.Resources[0]&#46;MasterZones[0]
 * 		slaveZone := _default.Resources[0]&#46;SlaveZones[1]
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleMaster, err := vpc.NewSwitch(ctx, "example_master", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.1.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(masterZone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSlave, err := vpc.NewSwitch(ctx, "example_slave", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(slaveZone),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 			ProtectionLevel: pulumi.String("REDUCED"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			TransitRouterName: pulumi.String(name),
 * 			CenId:             exampleInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterVpcAttachment(ctx, "example", &cen.TransitRouterVpcAttachmentArgs{
 * 			CenId:           exampleInstance.ID(),
 * 			TransitRouterId: exampleTransitRouter.TransitRouterId,
 * 			VpcId:           example.ID(),
 * 			ZoneMappings: cen.TransitRouterVpcAttachmentZoneMappingArray{
 * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
 * 					ZoneId:    pulumi.String(masterZone),
 * 					VswitchId: exampleMaster.ID(),
 * 				},
 * 				&cen.TransitRouterVpcAttachmentZoneMappingArgs{
 * 					ZoneId:    pulumi.String(slaveZone),
 * 					VswitchId: exampleSlave.ID(),
 * 				},
 * 			},
 * 			TransitRouterAttachmentName:        pulumi.String(name),
 * 			TransitRouterAttachmentDescription: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.CenFunctions;
 * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVpcAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs;
 * import com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = CenFunctions.getTransitRouterAvailableResources();
 *         final var masterZone = default_.resources()[0]&#46;masterZones()[0];
 *         final var slaveZone = default_.resources()[0]&#46;slaveZones()[1];
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var exampleMaster = new Switch("exampleMaster", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("192.168.1.0/24")
 *             .vpcId(example.id())
 *             .zoneId(masterZone)
 *             .build());
 *         var exampleSlave = new Switch("exampleSlave", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .vpcId(example.id())
 *             .zoneId(slaveZone)
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .protectionLevel("REDUCED")
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .transitRouterName(name)
 *             .cenId(exampleInstance.id())
 *             .build());
 *         var exampleTransitRouterVpcAttachment = new TransitRouterVpcAttachment("exampleTransitRouterVpcAttachment", TransitRouterVpcAttachmentArgs.builder()
 *             .cenId(exampleInstance.id())
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .vpcId(example.id())
 *             .zoneMappings(
 *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
 *                     .zoneId(masterZone)
 *                     .vswitchId(exampleMaster.id())
 *                     .build(),
 *                 TransitRouterVpcAttachmentZoneMappingArgs.builder()
 *                     .zoneId(slaveZone)
 *                     .vswitchId(exampleSlave.id())
 *                     .build())
 *             .transitRouterAttachmentName(name)
 *             .transitRouterAttachmentDescription(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   exampleMaster:
 *     type: alicloud:vpc:Switch
 *     name: example_master
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 192.168.1.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${masterZone}
 *   exampleSlave:
 *     type: alicloud:vpc:Switch
 *     name: example_slave
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${slaveZone}
 *   exampleInstance:
 *     type: alicloud:cen:Instance
 *     name: example
 *     properties:
 *       cenInstanceName: ${name}
 *       protectionLevel: REDUCED
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       transitRouterName: ${name}
 *       cenId: ${exampleInstance.id}
 *   exampleTransitRouterVpcAttachment:
 *     type: alicloud:cen:TransitRouterVpcAttachment
 *     name: example
 *     properties:
 *       cenId: ${exampleInstance.id}
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       vpcId: ${example.id}
 *       zoneMappings:
 *         - zoneId: ${masterZone}
 *           vswitchId: ${exampleMaster.id}
 *         - zoneId: ${slaveZone}
 *           vswitchId: ${exampleSlave.id}
 *       transitRouterAttachmentName: ${name}
 *       transitRouterAttachmentDescription: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cen:getTransitRouterAvailableResources
 *       Arguments: {}
 *   masterZone: ${default.resources[0]&#46;masterZones[0]}
 *   slaveZone: ${default.resources[0]&#46;slaveZones[1]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CEN Transit Router VPC Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterVpcAttachment:TransitRouterVpcAttachment example <cen_id>:<transit_router_attachment_id>
 * ```
 * @property autoPublishRouteEnabled Whether the transit router is automatically published to the VPC instance. Default value: `false`. Valid values:
 * @property cenId The ID of the CEN.
 * @property dryRun The dry run.
 * @property paymentType The payment type of the resource. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`.
 * @property resourceType The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
 * @property routeTableAssociationEnabled Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
 * @property routeTablePropagationEnabled Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
 * @property tags A mapping of tags to assign to the resource.
 * @property transitRouterAttachmentDescription The description of the transit router vbr attachment.
 * @property transitRouterAttachmentName The name of the transit router vbr attachment.
 * @property transitRouterId The ID of the transit router.
 * @property vpcId The ID of the VPC.
 * @property vpcOwnerId The owner id of vpc.
 * @property zoneMappings The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
 * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
 */
public data class TransitRouterVpcAttachmentArgs(
    public val autoPublishRouteEnabled: Output<Boolean>? = null,
    public val cenId: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val paymentType: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    @Deprecated(
        message = """
  Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead.
  """,
    )
    public val routeTableAssociationEnabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead.
  """,
    )
    public val routeTablePropagationEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitRouterAttachmentDescription: Output<String>? = null,
    public val transitRouterAttachmentName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcOwnerId: Output<String>? = null,
    public val zoneMappings: Output<List<TransitRouterVpcAttachmentZoneMappingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs =
        com.pulumi.alicloud.cen.TransitRouterVpcAttachmentArgs.builder()
            .autoPublishRouteEnabled(autoPublishRouteEnabled?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .routeTableAssociationEnabled(routeTableAssociationEnabled?.applyValue({ args0 -> args0 }))
            .routeTablePropagationEnabled(routeTablePropagationEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitRouterAttachmentDescription(
                transitRouterAttachmentDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterAttachmentName(transitRouterAttachmentName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcOwnerId(vpcOwnerId?.applyValue({ args0 -> args0 }))
            .zoneMappings(
                zoneMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TransitRouterVpcAttachmentArgs].
 */
@PulumiTagMarker
public class TransitRouterVpcAttachmentArgsBuilder internal constructor() {
    private var autoPublishRouteEnabled: Output<Boolean>? = null

    private var cenId: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var paymentType: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var routeTableAssociationEnabled: Output<Boolean>? = null

    private var routeTablePropagationEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitRouterAttachmentDescription: Output<String>? = null

    private var transitRouterAttachmentName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcOwnerId: Output<String>? = null

    private var zoneMappings: Output<List<TransitRouterVpcAttachmentZoneMappingArgs>>? = null

    /**
     * @param value Whether the transit router is automatically published to the VPC instance. Default value: `false`. Valid values:
     */
    @JvmName("omupwefrfffjtadw")
    public suspend fun autoPublishRouteEnabled(`value`: Output<Boolean>) {
        this.autoPublishRouteEnabled = value
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("qhciesxjwawqlice")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value The dry run.
     */
    @JvmName("qokdlenuoldxlatm")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The payment type of the resource. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`.
     */
    @JvmName("jtqriilffvmtyciy")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
     */
    @JvmName("cmppdcwadsyqgvkh")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
     */
    @Deprecated(
        message = """
  Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead.
  """,
    )
    @JvmName("qktdhjcxmtplavko")
    public suspend fun routeTableAssociationEnabled(`value`: Output<Boolean>) {
        this.routeTableAssociationEnabled = value
    }

    /**
     * @param value Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
     */
    @Deprecated(
        message = """
  Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead.
  """,
    )
    @JvmName("hyqhlfwgjsykspwm")
    public suspend fun routeTablePropagationEnabled(`value`: Output<Boolean>) {
        this.routeTablePropagationEnabled = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("rlyjiwgyrgjncvej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the transit router vbr attachment.
     */
    @JvmName("jirtafyjhbesewhc")
    public suspend fun transitRouterAttachmentDescription(`value`: Output<String>) {
        this.transitRouterAttachmentDescription = value
    }

    /**
     * @param value The name of the transit router vbr attachment.
     */
    @JvmName("xujdjfhhbkiaahci")
    public suspend fun transitRouterAttachmentName(`value`: Output<String>) {
        this.transitRouterAttachmentName = value
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("uxeqcewmpdlvsaht")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("pbclkqhglyustlqx")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The owner id of vpc.
     */
    @JvmName("iiuqrdhiqfvwvacx")
    public suspend fun vpcOwnerId(`value`: Output<String>) {
        this.vpcOwnerId = value
    }

    /**
     * @param value The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("hgxqkmsuvjgcaweh")
    public suspend fun zoneMappings(`value`: Output<List<TransitRouterVpcAttachmentZoneMappingArgs>>) {
        this.zoneMappings = value
    }

    @JvmName("liunlvsdbasheebo")
    public suspend fun zoneMappings(vararg values: Output<TransitRouterVpcAttachmentZoneMappingArgs>) {
        this.zoneMappings = Output.all(values.asList())
    }

    /**
     * @param values The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("luirynlhibxerupu")
    public suspend fun zoneMappings(values: List<Output<TransitRouterVpcAttachmentZoneMappingArgs>>) {
        this.zoneMappings = Output.all(values)
    }

    /**
     * @param value Whether the transit router is automatically published to the VPC instance. Default value: `false`. Valid values:
     */
    @JvmName("eaulbshqhtevmgcs")
    public suspend fun autoPublishRouteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPublishRouteEnabled = mapped
    }

    /**
     * @param value The ID of the CEN.
     */
    @JvmName("cewdwpodhkmacudp")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value The dry run.
     */
    @JvmName("xmletnaffswveewg")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The payment type of the resource. Default value: `PayAsYouGo`. Valid values: `PayAsYouGo`.
     */
    @JvmName("jwmqhfqxcntcybgr")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The resource type of the transit router vpc attachment. Default value: `VPC`. Valid values: `VPC`.
     */
    @JvmName("bxdxqjvrluflfggd")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
     */
    @Deprecated(
        message = """
  Field `route_table_association_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTableAssociation` instead.
  """,
    )
    @JvmName("dnpxiaygkwqtjhup")
    public suspend fun routeTableAssociationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableAssociationEnabled = mapped
    }

    /**
     * @param value Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
     */
    @Deprecated(
        message = """
  Field `route_table_propagation_enabled` has been deprecated from provider version 1.192.0. Please
      use the resource `alicloud.cen.TransitRouterRouteTablePropagation` instead.
  """,
    )
    @JvmName("qonupepiykdmvdrh")
    public suspend fun routeTablePropagationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTablePropagationEnabled = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("koyhfjukpueqtvnf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("aulgymoiwglxckkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The description of the transit router vbr attachment.
     */
    @JvmName("qclswhrcgiuykbxs")
    public suspend fun transitRouterAttachmentDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentDescription = mapped
    }

    /**
     * @param value The name of the transit router vbr attachment.
     */
    @JvmName("sxnsiatskogdskkd")
    public suspend fun transitRouterAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentName = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("gcvymftamehxgqbt")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("bqfnupeknvdlbtvh")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The owner id of vpc.
     */
    @JvmName("jotryphotcatxdip")
    public suspend fun vpcOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcOwnerId = mapped
    }

    /**
     * @param value The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("psswrobqvaqaqnig")
    public suspend fun zoneMappings(`value`: List<TransitRouterVpcAttachmentZoneMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("pngraohihasyuuyu")
    public suspend fun zoneMappings(argument: List<suspend TransitRouterVpcAttachmentZoneMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TransitRouterVpcAttachmentZoneMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("ynfaqhgqxgxedloa")
    public suspend fun zoneMappings(vararg argument: suspend TransitRouterVpcAttachmentZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TransitRouterVpcAttachmentZoneMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param argument The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("raxvsoeflndkktwd")
    public suspend fun zoneMappings(argument: suspend TransitRouterVpcAttachmentZoneMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TransitRouterVpcAttachmentZoneMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.zoneMappings = mapped
    }

    /**
     * @param values The list of zone mapping of the VPC. See `zone_mappings` below. **NOTE:** From version 1.184.0, `zone_mappings` can be modified.
     * > **NOTE:** The Zone of CEN has MasterZone and SlaveZone, first zone_id of zone_mapping need be MasterZone. We have a API to describeZones[API](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-listtransitrouteravailableresource)
     */
    @JvmName("nfwgxlyvqsiqeqfb")
    public suspend fun zoneMappings(vararg values: TransitRouterVpcAttachmentZoneMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneMappings = mapped
    }

    internal fun build(): TransitRouterVpcAttachmentArgs = TransitRouterVpcAttachmentArgs(
        autoPublishRouteEnabled = autoPublishRouteEnabled,
        cenId = cenId,
        dryRun = dryRun,
        paymentType = paymentType,
        resourceType = resourceType,
        routeTableAssociationEnabled = routeTableAssociationEnabled,
        routeTablePropagationEnabled = routeTablePropagationEnabled,
        tags = tags,
        transitRouterAttachmentDescription = transitRouterAttachmentDescription,
        transitRouterAttachmentName = transitRouterAttachmentName,
        transitRouterId = transitRouterId,
        vpcId = vpcId,
        vpcOwnerId = vpcOwnerId,
        zoneMappings = zoneMappings,
    )
}
