@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin

import com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs.builder
import com.pulumi.alicloud.cen.kotlin.inputs.TransitRouterVpnAttachmentZoneArgs
import com.pulumi.alicloud.cen.kotlin.inputs.TransitRouterVpnAttachmentZoneArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cloud Enterprise Network (CEN) Transit Router Vpn Attachment resource.
 * For information about Cloud Enterprise Network (CEN) Transit Router Vpn Attachment and how to use it, see [What is Transit Router Vpn Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervpnattachment).
 * > **NOTE:** Available since v1.183.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const default = alicloud.cen.getTransitRouterAvailableResources({});
 * const example = new alicloud.cen.Instance("example", {cenInstanceName: name});
 * const exampleTransitRouter = new alicloud.cen.TransitRouter("example", {
 *     cenId: example.id,
 *     transitRouterDescription: name,
 *     transitRouterName: name,
 * });
 * const exampleCustomerGateway = new alicloud.vpn.CustomerGateway("example", {
 *     name: name,
 *     ipAddress: "42.104.22.210",
 *     asn: "45014",
 *     description: name,
 * });
 * const exampleGatewayVpnAttachment = new alicloud.vpn.GatewayVpnAttachment("example", {
 *     customerGatewayId: exampleCustomerGateway.id,
 *     networkType: "public",
 *     localSubnet: "0.0.0.0/0",
 *     remoteSubnet: "0.0.0.0/0",
 *     effectImmediately: false,
 *     ikeConfig: {
 *         ikeAuthAlg: "md5",
 *         ikeEncAlg: "des",
 *         ikeVersion: "ikev2",
 *         ikeMode: "main",
 *         ikeLifetime: 86400,
 *         psk: "tf-testvpn2",
 *         ikePfs: "group1",
 *         remoteId: "testbob2",
 *         localId: "testalice2",
 *     },
 *     ipsecConfig: {
 *         ipsecPfs: "group5",
 *         ipsecEncAlg: "des",
 *         ipsecAuthAlg: "md5",
 *         ipsecLifetime: 86400,
 *     },
 *     bgpConfig: {
 *         enable: true,
 *         localAsn: 45014,
 *         tunnelCidr: "169.254.11.0/30",
 *         localBgpIp: "169.254.11.1",
 *     },
 *     healthCheckConfig: {
 *         enable: true,
 *         sip: "192.168.1.1",
 *         dip: "10.0.0.1",
 *         interval: 10,
 *         retry: 10,
 *         policy: "revoke_route",
 *     },
 *     enableDpd: true,
 *     enableNatTraversal: true,
 *     vpnAttachmentName: name,
 * });
 * const exampleTransitRouterCidr = new alicloud.cen.TransitRouterCidr("example", {
 *     transitRouterId: exampleTransitRouter.transitRouterId,
 *     cidr: "192.168.0.0/16",
 *     transitRouterCidrName: name,
 *     description: name,
 *     publishCidrRoute: true,
 * });
 * const exampleTransitRouterVpnAttachment = new alicloud.cen.TransitRouterVpnAttachment("example", {
 *     autoPublishRouteEnabled: false,
 *     transitRouterAttachmentDescription: name,
 *     transitRouterAttachmentName: name,
 *     cenId: exampleTransitRouter.cenId,
 *     transitRouterId: exampleTransitRouterCidr.transitRouterId,
 *     vpnId: exampleGatewayVpnAttachment.id,
 *     zones: [{
 *         zoneId: _default.then(_default => _default.resources?.[0]?&#46;masterZones?&#46;[0]),
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.cen.get_transit_router_available_resources()
 * example = alicloud.cen.Instance("example", cen_instance_name=name)
 * example_transit_router = alicloud.cen.TransitRouter("example",
 *     cen_id=example.id,
 *     transit_router_description=name,
 *     transit_router_name=name)
 * example_customer_gateway = alicloud.vpn.CustomerGateway("example",
 *     name=name,
 *     ip_address="42.104.22.210",
 *     asn="45014",
 *     description=name)
 * example_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("example",
 *     customer_gateway_id=example_customer_gateway.id,
 *     network_type="public",
 *     local_subnet="0.0.0.0/0",
 *     remote_subnet="0.0.0.0/0",
 *     effect_immediately=False,
 *     ike_config={
 *         "ike_auth_alg": "md5",
 *         "ike_enc_alg": "des",
 *         "ike_version": "ikev2",
 *         "ike_mode": "main",
 *         "ike_lifetime": 86400,
 *         "psk": "tf-testvpn2",
 *         "ike_pfs": "group1",
 *         "remote_id": "testbob2",
 *         "local_id": "testalice2",
 *     },
 *     ipsec_config={
 *         "ipsec_pfs": "group5",
 *         "ipsec_enc_alg": "des",
 *         "ipsec_auth_alg": "md5",
 *         "ipsec_lifetime": 86400,
 *     },
 *     bgp_config={
 *         "enable": True,
 *         "local_asn": 45014,
 *         "tunnel_cidr": "169.254.11.0/30",
 *         "local_bgp_ip": "169.254.11.1",
 *     },
 *     health_check_config={
 *         "enable": True,
 *         "sip": "192.168.1.1",
 *         "dip": "10.0.0.1",
 *         "interval": 10,
 *         "retry": 10,
 *         "policy": "revoke_route",
 *     },
 *     enable_dpd=True,
 *     enable_nat_traversal=True,
 *     vpn_attachment_name=name)
 * example_transit_router_cidr = alicloud.cen.TransitRouterCidr("example",
 *     transit_router_id=example_transit_router.transit_router_id,
 *     cidr="192.168.0.0/16",
 *     transit_router_cidr_name=name,
 *     description=name,
 *     publish_cidr_route=True)
 * example_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("example",
 *     auto_publish_route_enabled=False,
 *     transit_router_attachment_description=name,
 *     transit_router_attachment_name=name,
 *     cen_id=example_transit_router.cen_id,
 *     transit_router_id=example_transit_router_cidr.transit_router_id,
 *     vpn_id=example_gateway_vpn_attachment.id,
 *     zones=[{
 *         "zone_id": default.resources[0]&#46;master_zones[0],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = AliCloud.Cen.GetTransitRouterAvailableResources.Invoke();
 *     var example = new AliCloud.Cen.Instance("example", new()
 *     {
 *         CenInstanceName = name,
 *     });
 *     var exampleTransitRouter = new AliCloud.Cen.TransitRouter("example", new()
 *     {
 *         CenId = example.Id,
 *         TransitRouterDescription = name,
 *         TransitRouterName = name,
 *     });
 *     var exampleCustomerGateway = new AliCloud.Vpn.CustomerGateway("example", new()
 *     {
 *         Name = name,
 *         IpAddress = "42.104.22.210",
 *         Asn = "45014",
 *         Description = name,
 *     });
 *     var exampleGatewayVpnAttachment = new AliCloud.Vpn.GatewayVpnAttachment("example", new()
 *     {
 *         CustomerGatewayId = exampleCustomerGateway.Id,
 *         NetworkType = "public",
 *         LocalSubnet = "0.0.0.0/0",
 *         RemoteSubnet = "0.0.0.0/0",
 *         EffectImmediately = false,
 *         IkeConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIkeConfigArgs
 *         {
 *             IkeAuthAlg = "md5",
 *             IkeEncAlg = "des",
 *             IkeVersion = "ikev2",
 *             IkeMode = "main",
 *             IkeLifetime = 86400,
 *             Psk = "tf-testvpn2",
 *             IkePfs = "group1",
 *             RemoteId = "testbob2",
 *             LocalId = "testalice2",
 *         },
 *         IpsecConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentIpsecConfigArgs
 *         {
 *             IpsecPfs = "group5",
 *             IpsecEncAlg = "des",
 *             IpsecAuthAlg = "md5",
 *             IpsecLifetime = 86400,
 *         },
 *         BgpConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentBgpConfigArgs
 *         {
 *             Enable = true,
 *             LocalAsn = 45014,
 *             TunnelCidr = "169.254.11.0/30",
 *             LocalBgpIp = "169.254.11.1",
 *         },
 *         HealthCheckConfig = new AliCloud.Vpn.Inputs.GatewayVpnAttachmentHealthCheckConfigArgs
 *         {
 *             Enable = true,
 *             Sip = "192.168.1.1",
 *             Dip = "10.0.0.1",
 *             Interval = 10,
 *             Retry = 10,
 *             Policy = "revoke_route",
 *         },
 *         EnableDpd = true,
 *         EnableNatTraversal = true,
 *         VpnAttachmentName = name,
 *     });
 *     var exampleTransitRouterCidr = new AliCloud.Cen.TransitRouterCidr("example", new()
 *     {
 *         TransitRouterId = exampleTransitRouter.TransitRouterId,
 *         Cidr = "192.168.0.0/16",
 *         TransitRouterCidrName = name,
 *         Description = name,
 *         PublishCidrRoute = true,
 *     });
 *     var exampleTransitRouterVpnAttachment = new AliCloud.Cen.TransitRouterVpnAttachment("example", new()
 *     {
 *         AutoPublishRouteEnabled = false,
 *         TransitRouterAttachmentDescription = name,
 *         TransitRouterAttachmentName = name,
 *         CenId = exampleTransitRouter.CenId,
 *         TransitRouterId = exampleTransitRouterCidr.TransitRouterId,
 *         VpnId = exampleGatewayVpnAttachment.Id,
 *         Zones = new[]
 *         {
 *             new AliCloud.Cen.Inputs.TransitRouterVpnAttachmentZoneArgs
 *             {
 *                 ZoneId = @default.Apply(@default => @default.Apply(getTransitRouterAvailableResourcesResult => getTransitRouterAvailableResourcesResult.Resources[0]?&#46;MasterZones[0])),
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cen"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := cen.GetTransitRouterAvailableResources(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := cen.NewInstance(ctx, "example", &cen.InstanceArgs{
 * 			CenInstanceName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouter, err := cen.NewTransitRouter(ctx, "example", &cen.TransitRouterArgs{
 * 			CenId:                    example.ID(),
 * 			TransitRouterDescription: pulumi.String(name),
 * 			TransitRouterName:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCustomerGateway, err := vpn.NewCustomerGateway(ctx, "example", &vpn.CustomerGatewayArgs{
 * 			Name:        pulumi.String(name),
 * 			IpAddress:   pulumi.String("42.104.22.210"),
 * 			Asn:         pulumi.String("45014"),
 * 			Description: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGatewayVpnAttachment, err := vpn.NewGatewayVpnAttachment(ctx, "example", &vpn.GatewayVpnAttachmentArgs{
 * 			CustomerGatewayId: exampleCustomerGateway.ID(),
 * 			NetworkType:       pulumi.String("public"),
 * 			LocalSubnet:       pulumi.String("0.0.0.0/0"),
 * 			RemoteSubnet:      pulumi.String("0.0.0.0/0"),
 * 			EffectImmediately: pulumi.Bool(false),
 * 			IkeConfig: &vpn.GatewayVpnAttachmentIkeConfigArgs{
 * 				IkeAuthAlg:  pulumi.String("md5"),
 * 				IkeEncAlg:   pulumi.String("des"),
 * 				IkeVersion:  pulumi.String("ikev2"),
 * 				IkeMode:     pulumi.String("main"),
 * 				IkeLifetime: pulumi.Int(86400),
 * 				Psk:         pulumi.String("tf-testvpn2"),
 * 				IkePfs:      pulumi.String("group1"),
 * 				RemoteId:    pulumi.String("testbob2"),
 * 				LocalId:     pulumi.String("testalice2"),
 * 			},
 * 			IpsecConfig: &vpn.GatewayVpnAttachmentIpsecConfigArgs{
 * 				IpsecPfs:      pulumi.String("group5"),
 * 				IpsecEncAlg:   pulumi.String("des"),
 * 				IpsecAuthAlg:  pulumi.String("md5"),
 * 				IpsecLifetime: pulumi.Int(86400),
 * 			},
 * 			BgpConfig: &vpn.GatewayVpnAttachmentBgpConfigArgs{
 * 				Enable:     pulumi.Bool(true),
 * 				LocalAsn:   pulumi.Int(45014),
 * 				TunnelCidr: pulumi.String("169.254.11.0/30"),
 * 				LocalBgpIp: pulumi.String("169.254.11.1"),
 * 			},
 * 			HealthCheckConfig: &vpn.GatewayVpnAttachmentHealthCheckConfigArgs{
 * 				Enable:   pulumi.Bool(true),
 * 				Sip:      pulumi.String("192.168.1.1"),
 * 				Dip:      pulumi.String("10.0.0.1"),
 * 				Interval: pulumi.Int(10),
 * 				Retry:    pulumi.Int(10),
 * 				Policy:   pulumi.String("revoke_route"),
 * 			},
 * 			EnableDpd:          pulumi.Bool(true),
 * 			EnableNatTraversal: pulumi.Bool(true),
 * 			VpnAttachmentName:  pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleTransitRouterCidr, err := cen.NewTransitRouterCidr(ctx, "example", &cen.TransitRouterCidrArgs{
 * 			TransitRouterId:       exampleTransitRouter.TransitRouterId,
 * 			Cidr:                  pulumi.String("192.168.0.0/16"),
 * 			TransitRouterCidrName: pulumi.String(name),
 * 			Description:           pulumi.String(name),
 * 			PublishCidrRoute:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cen.NewTransitRouterVpnAttachment(ctx, "example", &cen.TransitRouterVpnAttachmentArgs{
 * 			AutoPublishRouteEnabled:            pulumi.Bool(false),
 * 			TransitRouterAttachmentDescription: pulumi.String(name),
 * 			TransitRouterAttachmentName:        pulumi.String(name),
 * 			CenId:                              exampleTransitRouter.CenId,
 * 			TransitRouterId:                    exampleTransitRouterCidr.TransitRouterId,
 * 			VpnId:                              exampleGatewayVpnAttachment.ID(),
 * 			Zones: cen.TransitRouterVpnAttachmentZoneArray{
 * 				&cen.TransitRouterVpnAttachmentZoneArgs{
 * 					ZoneId: pulumi.String(_default.Resources[0]&#46;MasterZones[0]),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cen.CenFunctions;
 * import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesArgs;
 * import com.pulumi.alicloud.cen.Instance;
 * import com.pulumi.alicloud.cen.InstanceArgs;
 * import com.pulumi.alicloud.cen.TransitRouter;
 * import com.pulumi.alicloud.cen.TransitRouterArgs;
 * import com.pulumi.alicloud.vpn.CustomerGateway;
 * import com.pulumi.alicloud.vpn.CustomerGatewayArgs;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachment;
 * import com.pulumi.alicloud.vpn.GatewayVpnAttachmentArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIkeConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentIpsecConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentBgpConfigArgs;
 * import com.pulumi.alicloud.vpn.inputs.GatewayVpnAttachmentHealthCheckConfigArgs;
 * import com.pulumi.alicloud.cen.TransitRouterCidr;
 * import com.pulumi.alicloud.cen.TransitRouterCidrArgs;
 * import com.pulumi.alicloud.cen.TransitRouterVpnAttachment;
 * import com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs;
 * import com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var default = CenFunctions.getTransitRouterAvailableResources();
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .cenInstanceName(name)
 *             .build());
 *         var exampleTransitRouter = new TransitRouter("exampleTransitRouter", TransitRouterArgs.builder()
 *             .cenId(example.id())
 *             .transitRouterDescription(name)
 *             .transitRouterName(name)
 *             .build());
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .name(name)
 *             .ipAddress("42.104.22.210")
 *             .asn("45014")
 *             .description(name)
 *             .build());
 *         var exampleGatewayVpnAttachment = new GatewayVpnAttachment("exampleGatewayVpnAttachment", GatewayVpnAttachmentArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .networkType("public")
 *             .localSubnet("0.0.0.0/0")
 *             .remoteSubnet("0.0.0.0/0")
 *             .effectImmediately(false)
 *             .ikeConfig(GatewayVpnAttachmentIkeConfigArgs.builder()
 *                 .ikeAuthAlg("md5")
 *                 .ikeEncAlg("des")
 *                 .ikeVersion("ikev2")
 *                 .ikeMode("main")
 *                 .ikeLifetime(86400)
 *                 .psk("tf-testvpn2")
 *                 .ikePfs("group1")
 *                 .remoteId("testbob2")
 *                 .localId("testalice2")
 *                 .build())
 *             .ipsecConfig(GatewayVpnAttachmentIpsecConfigArgs.builder()
 *                 .ipsecPfs("group5")
 *                 .ipsecEncAlg("des")
 *                 .ipsecAuthAlg("md5")
 *                 .ipsecLifetime(86400)
 *                 .build())
 *             .bgpConfig(GatewayVpnAttachmentBgpConfigArgs.builder()
 *                 .enable(true)
 *                 .localAsn(45014)
 *                 .tunnelCidr("169.254.11.0/30")
 *                 .localBgpIp("169.254.11.1")
 *                 .build())
 *             .healthCheckConfig(GatewayVpnAttachmentHealthCheckConfigArgs.builder()
 *                 .enable(true)
 *                 .sip("192.168.1.1")
 *                 .dip("10.0.0.1")
 *                 .interval(10)
 *                 .retry(10)
 *                 .policy("revoke_route")
 *                 .build())
 *             .enableDpd(true)
 *             .enableNatTraversal(true)
 *             .vpnAttachmentName(name)
 *             .build());
 *         var exampleTransitRouterCidr = new TransitRouterCidr("exampleTransitRouterCidr", TransitRouterCidrArgs.builder()
 *             .transitRouterId(exampleTransitRouter.transitRouterId())
 *             .cidr("192.168.0.0/16")
 *             .transitRouterCidrName(name)
 *             .description(name)
 *             .publishCidrRoute(true)
 *             .build());
 *         var exampleTransitRouterVpnAttachment = new TransitRouterVpnAttachment("exampleTransitRouterVpnAttachment", TransitRouterVpnAttachmentArgs.builder()
 *             .autoPublishRouteEnabled(false)
 *             .transitRouterAttachmentDescription(name)
 *             .transitRouterAttachmentName(name)
 *             .cenId(exampleTransitRouter.cenId())
 *             .transitRouterId(exampleTransitRouterCidr.transitRouterId())
 *             .vpnId(exampleGatewayVpnAttachment.id())
 *             .zones(TransitRouterVpnAttachmentZoneArgs.builder()
 *                 .zoneId(default_.resources()[0]&#46;masterZones()[0])
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   example:
 *     type: alicloud:cen:Instance
 *     properties:
 *       cenInstanceName: ${name}
 *   exampleTransitRouter:
 *     type: alicloud:cen:TransitRouter
 *     name: example
 *     properties:
 *       cenId: ${example.id}
 *       transitRouterDescription: ${name}
 *       transitRouterName: ${name}
 *   exampleCustomerGateway:
 *     type: alicloud:vpn:CustomerGateway
 *     name: example
 *     properties:
 *       name: ${name}
 *       ipAddress: 42.104.22.210
 *       asn: '45014'
 *       description: ${name}
 *   exampleGatewayVpnAttachment:
 *     type: alicloud:vpn:GatewayVpnAttachment
 *     name: example
 *     properties:
 *       customerGatewayId: ${exampleCustomerGateway.id}
 *       networkType: public
 *       localSubnet: 0.0.0.0/0
 *       remoteSubnet: 0.0.0.0/0
 *       effectImmediately: false
 *       ikeConfig:
 *         ikeAuthAlg: md5
 *         ikeEncAlg: des
 *         ikeVersion: ikev2
 *         ikeMode: main
 *         ikeLifetime: 86400
 *         psk: tf-testvpn2
 *         ikePfs: group1
 *         remoteId: testbob2
 *         localId: testalice2
 *       ipsecConfig:
 *         ipsecPfs: group5
 *         ipsecEncAlg: des
 *         ipsecAuthAlg: md5
 *         ipsecLifetime: 86400
 *       bgpConfig:
 *         enable: true
 *         localAsn: 45014
 *         tunnelCidr: 169.254.11.0/30
 *         localBgpIp: 169.254.11.1
 *       healthCheckConfig:
 *         enable: true
 *         sip: 192.168.1.1
 *         dip: 10.0.0.1
 *         interval: 10
 *         retry: 10
 *         policy: revoke_route
 *       enableDpd: true
 *       enableNatTraversal: true
 *       vpnAttachmentName: ${name}
 *   exampleTransitRouterCidr:
 *     type: alicloud:cen:TransitRouterCidr
 *     name: example
 *     properties:
 *       transitRouterId: ${exampleTransitRouter.transitRouterId}
 *       cidr: 192.168.0.0/16
 *       transitRouterCidrName: ${name}
 *       description: ${name}
 *       publishCidrRoute: true
 *   exampleTransitRouterVpnAttachment:
 *     type: alicloud:cen:TransitRouterVpnAttachment
 *     name: example
 *     properties:
 *       autoPublishRouteEnabled: false
 *       transitRouterAttachmentDescription: ${name}
 *       transitRouterAttachmentName: ${name}
 *       cenId: ${exampleTransitRouter.cenId}
 *       transitRouterId: ${exampleTransitRouterCidr.transitRouterId}
 *       vpnId: ${exampleGatewayVpnAttachment.id}
 *       zones:
 *         - zoneId: ${default.resources[0]&#46;masterZones[0]}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:cen:getTransitRouterAvailableResources
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Cloud Enterprise Network (CEN) Transit Router Vpn Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cen/transitRouterVpnAttachment:TransitRouterVpnAttachment example <id>
 * ```
 * @property autoPublishRouteEnabled Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
 * @property cenId The id of the cen.
 * @property tags A mapping of tags to assign to the resource.
 * @property transitRouterAttachmentDescription The description of the VPN connection. The description can contain `2` to `256` characters. The description must start with English letters, but cannot start with `http://` or `https://`.
 * @property transitRouterAttachmentName The name of the VPN connection. The name must be `2` to `128` characters in length, and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
 * @property transitRouterId The ID of the forwarding router instance.
 * @property vpnId The id of the vpn.
 * @property vpnOwnerId The owner id of vpn. **NOTE:** You must set `vpn_owner_id`, if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
 * @property zones The list of zone mapping. See `zone` below.
 */
public data class TransitRouterVpnAttachmentArgs(
    public val autoPublishRouteEnabled: Output<Boolean>? = null,
    public val cenId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitRouterAttachmentDescription: Output<String>? = null,
    public val transitRouterAttachmentName: Output<String>? = null,
    public val transitRouterId: Output<String>? = null,
    public val vpnId: Output<String>? = null,
    public val vpnOwnerId: Output<String>? = null,
    public val zones: Output<List<TransitRouterVpnAttachmentZoneArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs =
        com.pulumi.alicloud.cen.TransitRouterVpnAttachmentArgs.builder()
            .autoPublishRouteEnabled(autoPublishRouteEnabled?.applyValue({ args0 -> args0 }))
            .cenId(cenId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitRouterAttachmentDescription(
                transitRouterAttachmentDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitRouterAttachmentName(transitRouterAttachmentName?.applyValue({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.applyValue({ args0 -> args0 }))
            .vpnId(vpnId?.applyValue({ args0 -> args0 }))
            .vpnOwnerId(vpnOwnerId?.applyValue({ args0 -> args0 }))
            .zones(
                zones?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TransitRouterVpnAttachmentArgs].
 */
@PulumiTagMarker
public class TransitRouterVpnAttachmentArgsBuilder internal constructor() {
    private var autoPublishRouteEnabled: Output<Boolean>? = null

    private var cenId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitRouterAttachmentDescription: Output<String>? = null

    private var transitRouterAttachmentName: Output<String>? = null

    private var transitRouterId: Output<String>? = null

    private var vpnId: Output<String>? = null

    private var vpnOwnerId: Output<String>? = null

    private var zones: Output<List<TransitRouterVpnAttachmentZoneArgs>>? = null

    /**
     * @param value Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
     */
    @JvmName("xowklxfkhgxlravq")
    public suspend fun autoPublishRouteEnabled(`value`: Output<Boolean>) {
        this.autoPublishRouteEnabled = value
    }

    /**
     * @param value The id of the cen.
     */
    @JvmName("hlgjnvbmftgohlbr")
    public suspend fun cenId(`value`: Output<String>) {
        this.cenId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("twppvilcwiculhgu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the VPN connection. The description can contain `2` to `256` characters. The description must start with English letters, but cannot start with `http://` or `https://`.
     */
    @JvmName("wbbisrpgtecnfdye")
    public suspend fun transitRouterAttachmentDescription(`value`: Output<String>) {
        this.transitRouterAttachmentDescription = value
    }

    /**
     * @param value The name of the VPN connection. The name must be `2` to `128` characters in length, and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("aqcxclikgypuuccx")
    public suspend fun transitRouterAttachmentName(`value`: Output<String>) {
        this.transitRouterAttachmentName = value
    }

    /**
     * @param value The ID of the forwarding router instance.
     */
    @JvmName("pknfppexagfpcjpy")
    public suspend fun transitRouterId(`value`: Output<String>) {
        this.transitRouterId = value
    }

    /**
     * @param value The id of the vpn.
     */
    @JvmName("hrhtdkqprxwojbxt")
    public suspend fun vpnId(`value`: Output<String>) {
        this.vpnId = value
    }

    /**
     * @param value The owner id of vpn. **NOTE:** You must set `vpn_owner_id`, if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
     */
    @JvmName("vjigfqpwbbbwkoof")
    public suspend fun vpnOwnerId(`value`: Output<String>) {
        this.vpnOwnerId = value
    }

    /**
     * @param value The list of zone mapping. See `zone` below.
     */
    @JvmName("yloptwbdredcovmn")
    public suspend fun zones(`value`: Output<List<TransitRouterVpnAttachmentZoneArgs>>) {
        this.zones = value
    }

    @JvmName("vnnsjmhwqnlxifhr")
    public suspend fun zones(vararg values: Output<TransitRouterVpnAttachmentZoneArgs>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The list of zone mapping. See `zone` below.
     */
    @JvmName("vughjjpnltcdvful")
    public suspend fun zones(values: List<Output<TransitRouterVpnAttachmentZoneArgs>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Whether to allow the forwarding router instance to automatically publish routing entries to IPsec connections.
     */
    @JvmName("vorubgrlbmeuilej")
    public suspend fun autoPublishRouteEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPublishRouteEnabled = mapped
    }

    /**
     * @param value The id of the cen.
     */
    @JvmName("bsmclvgwnjojlkbr")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cenId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ygrigjcgiqcgrheo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("hagpatxvondvmvtt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The description of the VPN connection. The description can contain `2` to `256` characters. The description must start with English letters, but cannot start with `http://` or `https://`.
     */
    @JvmName("vdolqpfpxihfiili")
    public suspend fun transitRouterAttachmentDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentDescription = mapped
    }

    /**
     * @param value The name of the VPN connection. The name must be `2` to `128` characters in length, and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("cxqnljsigeqkfpar")
    public suspend fun transitRouterAttachmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterAttachmentName = mapped
    }

    /**
     * @param value The ID of the forwarding router instance.
     */
    @JvmName("bxrggunxemwyhifl")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitRouterId = mapped
    }

    /**
     * @param value The id of the vpn.
     */
    @JvmName("sxveojkyonxawuay")
    public suspend fun vpnId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnId = mapped
    }

    /**
     * @param value The owner id of vpn. **NOTE:** You must set `vpn_owner_id`, if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
     */
    @JvmName("skhwcxjxiumajlfq")
    public suspend fun vpnOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnOwnerId = mapped
    }

    /**
     * @param value The list of zone mapping. See `zone` below.
     */
    @JvmName("eiufjoydbclyoymn")
    public suspend fun zones(`value`: List<TransitRouterVpnAttachmentZoneArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param argument The list of zone mapping. See `zone` below.
     */
    @JvmName("qjypxxcnudfnucuo")
    public suspend fun zones(argument: List<suspend TransitRouterVpnAttachmentZoneArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TransitRouterVpnAttachmentZoneArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zones = mapped
    }

    /**
     * @param argument The list of zone mapping. See `zone` below.
     */
    @JvmName("njtfhhcedrniiqeu")
    public suspend fun zones(vararg argument: suspend TransitRouterVpnAttachmentZoneArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TransitRouterVpnAttachmentZoneArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zones = mapped
    }

    /**
     * @param argument The list of zone mapping. See `zone` below.
     */
    @JvmName("gfdyxtvrjxggjdvr")
    public suspend fun zones(argument: suspend TransitRouterVpnAttachmentZoneArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TransitRouterVpnAttachmentZoneArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.zones = mapped
    }

    /**
     * @param values The list of zone mapping. See `zone` below.
     */
    @JvmName("psarmftuevfwgywm")
    public suspend fun zones(vararg values: TransitRouterVpnAttachmentZoneArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): TransitRouterVpnAttachmentArgs = TransitRouterVpnAttachmentArgs(
        autoPublishRouteEnabled = autoPublishRouteEnabled,
        cenId = cenId,
        tags = tags,
        transitRouterAttachmentDescription = transitRouterAttachmentDescription,
        transitRouterAttachmentName = transitRouterAttachmentName,
        transitRouterId = transitRouterId,
        vpnId = vpnId,
        vpnOwnerId = vpnOwnerId,
        zones = zones,
    )
}
