@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetBandwidthLimitsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBandwidthLimits.
 * @property instanceIds A list of CEN instances IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBandwidthLimitsPlainArgs(
    public val instanceIds: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetBandwidthLimitsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetBandwidthLimitsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetBandwidthLimitsPlainArgs.builder()
            .instanceIds(instanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBandwidthLimitsPlainArgs].
 */
@PulumiTagMarker
public class GetBandwidthLimitsPlainArgsBuilder internal constructor() {
    private var instanceIds: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of CEN instances IDs.
     */
    @JvmName("rgdxyfodqugunqfc")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param values A list of CEN instances IDs.
     */
    @JvmName("fgacddexnssplgtl")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ltkpikdcunoolwgl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBandwidthLimitsPlainArgs = GetBandwidthLimitsPlainArgs(
        instanceIds = instanceIds,
        outputFile = outputFile,
    )
}
