@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetBandwidthPackagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBandwidthPackages.
 * @property ids Limit search to a list of specific CEN Bandwidth Package IDs.
 * @property includeReservationData Indicates whether to include renewal data. Valid values: `true`: Return renewal data in the response. `false`: Do not return renewal data in the response.
 * @property instanceId ID of a CEN instance.
 * @property nameRegex A regex string to filter CEN Bandwidth Package by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
 */
public data class GetBandwidthPackagesPlainArgs(
    public val ids: List<String>? = null,
    public val includeReservationData: Boolean? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetBandwidthPackagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetBandwidthPackagesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetBandwidthPackagesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeReservationData(includeReservationData?.let({ args0 -> args0 }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBandwidthPackagesPlainArgs].
 */
@PulumiTagMarker
public class GetBandwidthPackagesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var includeReservationData: Boolean? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value Limit search to a list of specific CEN Bandwidth Package IDs.
     */
    @JvmName("kduwyoxaacqujsrl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values Limit search to a list of specific CEN Bandwidth Package IDs.
     */
    @JvmName("eigqueaujkejubyv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Indicates whether to include renewal data. Valid values: `true`: Return renewal data in the response. `false`: Do not return renewal data in the response.
     */
    @JvmName("mfldchpvypxqmnac")
    public suspend fun includeReservationData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeReservationData = mapped
    }

    /**
     * @param value ID of a CEN instance.
     */
    @JvmName("kqupsdyrjurqgvgg")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter CEN Bandwidth Package by name.
     */
    @JvmName("nrtpxfvyymlxrsln")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kwyjvrfpuywbahin")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
     */
    @JvmName("pvboufnxflkcmvnw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBandwidthPackagesPlainArgs = GetBandwidthPackagesPlainArgs(
        ids = ids,
        includeReservationData = includeReservationData,
        instanceId = instanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
