@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getChildInstanceRouteEntryToAttachments.
 * @property cenId The ID of the CEN instance.
 * @property childInstanceRouteTableId The first ID of the resource
 * @property ids Limit search to a list of specific IDs.The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceType ServiceType
 * @property transitRouterAttachmentId TransitRouterAttachmentId
 */
public data class GetChildInstanceRouteEntryToAttachmentsPlainArgs(
    public val cenId: String? = null,
    public val childInstanceRouteTableId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val serviceType: String? = null,
    public val transitRouterAttachmentId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetChildInstanceRouteEntryToAttachmentsPlainArgs.builder()
            .cenId(cenId?.let({ args0 -> args0 }))
            .childInstanceRouteTableId(childInstanceRouteTableId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceType(serviceType?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChildInstanceRouteEntryToAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetChildInstanceRouteEntryToAttachmentsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var childInstanceRouteTableId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var serviceType: String? = null

    private var transitRouterAttachmentId: String? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("xxitepmxticatroh")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value The first ID of the resource
     */
    @JvmName("gwyhiwmbplwjismt")
    public suspend fun childInstanceRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.childInstanceRouteTableId = mapped
    }

    /**
     * @param value Limit search to a list of specific IDs.The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
     */
    @JvmName("kjrdfdnxqosogevp")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values Limit search to a list of specific IDs.The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
     */
    @JvmName("qurriucerxxmdgnj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dinmafvcmgnhtjtj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value ServiceType
     */
    @JvmName("ualjdidifylkocay")
    public suspend fun serviceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceType = mapped
    }

    /**
     * @param value TransitRouterAttachmentId
     */
    @JvmName("aowukmnlcwtdgfhs")
    public suspend fun transitRouterAttachmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    internal fun build(): GetChildInstanceRouteEntryToAttachmentsPlainArgs =
        GetChildInstanceRouteEntryToAttachmentsPlainArgs(
            cenId = cenId,
            childInstanceRouteTableId = childInstanceRouteTableId ?: throw
                PulumiNullFieldException("childInstanceRouteTableId"),
            ids = ids,
            outputFile = outputFile,
            serviceType = serviceType,
            transitRouterAttachmentId = transitRouterAttachmentId ?: throw
                PulumiNullFieldException("transitRouterAttachmentId"),
        )
}
