@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetFlowlogsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFlowlogs.
 * @property cenId The ID of the CEN Instance.
 * @property description The description of flowlog.
 * @property ids A list of CEN flow log IDs.
 * @property logStoreName The name of the log store which is in the  `project_name` SLS project.
 * @property nameRegex A regex string to filter CEN flow logs by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property projectName The name of the SLS project.
 * @property status The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
 */
public data class GetFlowlogsPlainArgs(
    public val cenId: String? = null,
    public val description: String? = null,
    public val ids: List<String>? = null,
    public val logStoreName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val projectName: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetFlowlogsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetFlowlogsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetFlowlogsPlainArgs.builder()
            .cenId(cenId?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .logStoreName(logStoreName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .projectName(projectName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFlowlogsPlainArgs].
 */
@PulumiTagMarker
public class GetFlowlogsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var description: String? = null

    private var ids: List<String>? = null

    private var logStoreName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var projectName: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the CEN Instance.
     */
    @JvmName("ildncieakdapybfd")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value The description of flowlog.
     */
    @JvmName("kqackxecbtklkqtk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value A list of CEN flow log IDs.
     */
    @JvmName("cqgytogahnreinpd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN flow log IDs.
     */
    @JvmName("ulkkbtuhbndvnlux")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the log store which is in the  `project_name` SLS project.
     */
    @JvmName("whobrdmhgaxwutlc")
    public suspend fun logStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.logStoreName = mapped
    }

    /**
     * @param value A regex string to filter CEN flow logs by name.
     */
    @JvmName("xayrkicftpwxyiva")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lrmrnbdhkesueuut")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the SLS project.
     */
    @JvmName("etqoplckxkntsfub")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
     */
    @JvmName("fkqignixdpfryuba")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetFlowlogsPlainArgs = GetFlowlogsPlainArgs(
        cenId = cenId,
        description = description,
        ids = ids,
        logStoreName = logStoreName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        projectName = projectName,
        status = status,
    )
}
