@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetInstanceAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceAttachments.
 * @property childInstanceRegionId The region to which the network to be queried belongs.
 * @property childInstanceType The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
 * @property instanceId The ID of the CEN instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
 */
public data class GetInstanceAttachmentsPlainArgs(
    public val childInstanceRegionId: String? = null,
    public val childInstanceType: String? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetInstanceAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetInstanceAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetInstanceAttachmentsPlainArgs.builder()
            .childInstanceRegionId(childInstanceRegionId?.let({ args0 -> args0 }))
            .childInstanceType(childInstanceType?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceAttachmentsPlainArgsBuilder internal constructor() {
    private var childInstanceRegionId: String? = null

    private var childInstanceType: String? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The region to which the network to be queried belongs.
     */
    @JvmName("nyeovirdfdhbqncm")
    public suspend fun childInstanceRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.childInstanceRegionId = mapped
    }

    /**
     * @param value The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
     */
    @JvmName("hhwkretjllqafrbb")
    public suspend fun childInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.childInstanceType = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("ujtomyewnybcvati")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bqkrutedffwwwhjj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
     */
    @JvmName("ludmekbhslcfjcjm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetInstanceAttachmentsPlainArgs = GetInstanceAttachmentsPlainArgs(
        childInstanceRegionId = childInstanceRegionId,
        childInstanceType = childInstanceType,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        status = status,
    )
}
