@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInterRegionTrafficQosPolicies.
 * @property ids A list of Inter Region Traffic Qos Policy IDs.
 * @property nameRegex A regex string to filter results by Inter Region Traffic Qos Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
 * @property trafficQosPolicyDescription The description of the QoS policy.
 * @property trafficQosPolicyId The ID of the QoS policy.
 * @property trafficQosPolicyName The name of the QoS policy.
 * @property transitRouterAttachmentId The ID of the inter-region connection.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetInterRegionTrafficQosPoliciesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val trafficQosPolicyDescription: String? = null,
    public val trafficQosPolicyId: String? = null,
    public val trafficQosPolicyName: String? = null,
    public val transitRouterAttachmentId: String,
    public val transitRouterId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosPoliciesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosPoliciesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .trafficQosPolicyDescription(trafficQosPolicyDescription?.let({ args0 -> args0 }))
            .trafficQosPolicyId(trafficQosPolicyId?.let({ args0 -> args0 }))
            .trafficQosPolicyName(trafficQosPolicyName?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInterRegionTrafficQosPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetInterRegionTrafficQosPoliciesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var trafficQosPolicyDescription: String? = null

    private var trafficQosPolicyId: String? = null

    private var trafficQosPolicyName: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value A list of Inter Region Traffic Qos Policy IDs.
     */
    @JvmName("viapkjdehjfhasav")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Inter Region Traffic Qos Policy IDs.
     */
    @JvmName("hphiafgytkinlydw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Inter Region Traffic Qos Policy name.
     */
    @JvmName("pdfnomfadcmlolaa")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xnqbbupuvoilsxcw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
     */
    @JvmName("odffbmqskrabwcok")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The description of the QoS policy.
     */
    @JvmName("rgavxpjaygbixelf")
    public suspend fun trafficQosPolicyDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficQosPolicyDescription = mapped
    }

    /**
     * @param value The ID of the QoS policy.
     */
    @JvmName("iuauedypuxwqgftx")
    public suspend fun trafficQosPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficQosPolicyId = mapped
    }

    /**
     * @param value The name of the QoS policy.
     */
    @JvmName("uijablaiaatmcqfe")
    public suspend fun trafficQosPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.trafficQosPolicyName = mapped
    }

    /**
     * @param value The ID of the inter-region connection.
     */
    @JvmName("larlvrxsksdpmghd")
    public suspend fun transitRouterAttachmentId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("xdfpbqkexdkwjogb")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetInterRegionTrafficQosPoliciesPlainArgs =
        GetInterRegionTrafficQosPoliciesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            trafficQosPolicyDescription = trafficQosPolicyDescription,
            trafficQosPolicyId = trafficQosPolicyId,
            trafficQosPolicyName = trafficQosPolicyName,
            transitRouterAttachmentId = transitRouterAttachmentId ?: throw
                PulumiNullFieldException("transitRouterAttachmentId"),
            transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
        )
}
