@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosQueuesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInterRegionTrafficQosQueues.
 * @property ids A list of Inter Region Traffic Qos Queue IDs.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property trafficQosPolicyId The ID of the traffic scheduling policy.
 */
public data class GetInterRegionTrafficQosQueuesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val trafficQosPolicyId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosQueuesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosQueuesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetInterRegionTrafficQosQueuesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .trafficQosPolicyId(trafficQosPolicyId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInterRegionTrafficQosQueuesPlainArgs].
 */
@PulumiTagMarker
public class GetInterRegionTrafficQosQueuesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var trafficQosPolicyId: String? = null

    /**
     * @param value A list of Inter Region Traffic Qos Queue IDs.
     */
    @JvmName("femuxjtaukxccnxg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Inter Region Traffic Qos Queue IDs.
     */
    @JvmName("njoqsbvhvbrqxqbo")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("qyyicllkmcijtnpd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dnvmisiaapugnedx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the traffic scheduling policy.
     */
    @JvmName("hgblahxnxmgvnsyw")
    public suspend fun trafficQosPolicyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trafficQosPolicyId = mapped
    }

    internal fun build(): GetInterRegionTrafficQosQueuesPlainArgs =
        GetInterRegionTrafficQosQueuesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            trafficQosPolicyId = trafficQosPolicyId ?: throw PulumiNullFieldException("trafficQosPolicyId"),
        )
}
