@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetPrivateZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrivateZones.
 * @property cenId The ID of the CEN instance.
 * @property hostRegionId The service region. The service region is the target region of the PrivateZone service accessed through CEN.
 * @property ids A list of CEN private zone IDs. Each element format as `<cen_id>:<access_region_id>`.
 * **NOTE:** Before 1.162.0, each element same as `access_region_id`.
 * * `host_region_id ` - (Optional) The service region is the target region of the PrivateZone service accessed through CEN.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
 */
public data class GetPrivateZonesPlainArgs(
    public val cenId: String,
    public val hostRegionId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetPrivateZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetPrivateZonesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetPrivateZonesPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .hostRegionId(hostRegionId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateZonesPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateZonesPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var hostRegionId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("djqljhyxridmmtln")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value The service region. The service region is the target region of the PrivateZone service accessed through CEN.
     */
    @JvmName("svqfpprstiirmmvs")
    public suspend fun hostRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostRegionId = mapped
    }

    /**
     * @param value A list of CEN private zone IDs. Each element format as `<cen_id>:<access_region_id>`.
     * **NOTE:** Before 1.162.0, each element same as `access_region_id`.
     * * `host_region_id ` - (Optional) The service region is the target region of the PrivateZone service accessed through CEN.
     */
    @JvmName("ndivgtgsqxqfbgpu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN private zone IDs. Each element format as `<cen_id>:<access_region_id>`.
     * **NOTE:** Before 1.162.0, each element same as `access_region_id`.
     * * `host_region_id ` - (Optional) The service region is the target region of the PrivateZone service accessed through CEN.
     */
    @JvmName("lnaujjbpvcjfjtxe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pyewiwkdiyaovwlo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the PrivateZone service, including `Creating`, `Active` and `Deleting`.
     */
    @JvmName("sraydyoelqfsjxdy")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetPrivateZonesPlainArgs = GetPrivateZonesPlainArgs(
        cenId = cenId ?: throw PulumiNullFieldException("cenId"),
        hostRegionId = hostRegionId,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
