@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetRegionRouteEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegionRouteEntries.
 * @property instanceId ID of the CEN instance.
 * @property outputFile
 * @property regionId ID of the region.
 */
public data class GetRegionRouteEntriesPlainArgs(
    public val instanceId: String,
    public val outputFile: String? = null,
    public val regionId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetRegionRouteEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetRegionRouteEntriesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetRegionRouteEntriesPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .regionId(regionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegionRouteEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetRegionRouteEntriesPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var outputFile: String? = null

    private var regionId: String? = null

    /**
     * @param value ID of the CEN instance.
     */
    @JvmName("avwklafckkedwobo")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qurqoqgqlncpilok")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value ID of the region.
     */
    @JvmName("qxrwerojepwakrxc")
    public suspend fun regionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regionId = mapped
    }

    internal fun build(): GetRegionRouteEntriesPlainArgs = GetRegionRouteEntriesPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        regionId = regionId ?: throw PulumiNullFieldException("regionId"),
    )
}
