@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetRouteEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteEntries.
 * @property cidrBlock The destination CIDR block of the route entry to query.
 * @property instanceId ID of the CEN instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property routeTableId ID of the route table of the VPC or VBR.
 */
public data class GetRouteEntriesPlainArgs(
    public val cidrBlock: String? = null,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val routeTableId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetRouteEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetRouteEntriesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetRouteEntriesPlainArgs.builder()
            .cidrBlock(cidrBlock?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .routeTableId(routeTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteEntriesPlainArgsBuilder internal constructor() {
    private var cidrBlock: String? = null

    private var instanceId: String? = null

    private var outputFile: String? = null

    private var routeTableId: String? = null

    /**
     * @param value The destination CIDR block of the route entry to query.
     */
    @JvmName("ceulmcqdrrhkeymo")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cidrBlock = mapped
    }

    /**
     * @param value ID of the CEN instance.
     */
    @JvmName("vufoleynsuurfrny")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yqlqlniwcutlvcdu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value ID of the route table of the VPC or VBR.
     */
    @JvmName("qggffewlygwgtgyy")
    public suspend fun routeTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableId = mapped
    }

    internal fun build(): GetRouteEntriesPlainArgs = GetRouteEntriesPlainArgs(
        cidrBlock = cidrBlock,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        outputFile = outputFile,
        routeTableId = routeTableId ?: throw PulumiNullFieldException("routeTableId"),
    )
}
