@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetRouteMapsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteMaps.
 * @property cenId The ID of the CEN instance.
 * @property cenRegionId The ID of the region to which the CEN instance belongs.
 * @property descriptionRegex A regex string to filter CEN route map by description.
 * @property ids A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the route map, including `Creating`, `Active` and `Deleting`.
 * @property transmitDirection The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
 */
public data class GetRouteMapsPlainArgs(
    public val cenId: String,
    public val cenRegionId: String? = null,
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transmitDirection: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetRouteMapsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetRouteMapsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetRouteMapsPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .cenRegionId(cenRegionId?.let({ args0 -> args0 }))
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transmitDirection(transmitDirection?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteMapsPlainArgs].
 */
@PulumiTagMarker
public class GetRouteMapsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var cenRegionId: String? = null

    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transmitDirection: String? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("ggpmnaipnqbmulpb")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value The ID of the region to which the CEN instance belongs.
     */
    @JvmName("sskywkbxepnlrpff")
    public suspend fun cenRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cenRegionId = mapped
    }

    /**
     * @param value A regex string to filter CEN route map by description.
     */
    @JvmName("rvygruqlmuxlpuqj")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
     */
    @JvmName("gkfnlhejtcxbuwui")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN route map IDs. Each item formats as `<cen_id>:<route_map_id>`.
     */
    @JvmName("mtbxkfsjekxderko")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("evhyueedcwracqfy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the route map, including `Creating`, `Active` and `Deleting`.
     */
    @JvmName("ibwqacwbgvffgges")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The direction in which the route map is applied, including `RegionIn` and `RegionOut`.
     */
    @JvmName("paxlxhcjwmsrvmuj")
    public suspend fun transmitDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transmitDirection = mapped
    }

    internal fun build(): GetRouteMapsPlainArgs = GetRouteMapsPlainArgs(
        cenId = cenId ?: throw PulumiNullFieldException("cenId"),
        cenRegionId = cenRegionId,
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        status = status,
        transmitDirection = transmitDirection,
    )
}
