@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetRouteServicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteServices.
 * @property accessRegionId The region of the network instances that access the cloud services.
 * @property cenId The ID of the CEN instance.
 * @property host The domain name or IP address of the cloud service.
 * @property hostRegionId The region of the cloud service.
 * @property hostVpcId The VPC associated with the cloud service.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
 */
public data class GetRouteServicesPlainArgs(
    public val accessRegionId: String? = null,
    public val cenId: String,
    public val host: String? = null,
    public val hostRegionId: String? = null,
    public val hostVpcId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetRouteServicesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetRouteServicesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetRouteServicesPlainArgs.builder()
            .accessRegionId(accessRegionId?.let({ args0 -> args0 }))
            .cenId(cenId.let({ args0 -> args0 }))
            .host(host?.let({ args0 -> args0 }))
            .hostRegionId(hostRegionId?.let({ args0 -> args0 }))
            .hostVpcId(hostVpcId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteServicesPlainArgs].
 */
@PulumiTagMarker
public class GetRouteServicesPlainArgsBuilder internal constructor() {
    private var accessRegionId: String? = null

    private var cenId: String? = null

    private var host: String? = null

    private var hostRegionId: String? = null

    private var hostVpcId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The region of the network instances that access the cloud services.
     */
    @JvmName("cnjxjqcscafsmnkf")
    public suspend fun accessRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessRegionId = mapped
    }

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("gwjfisalvvxtjeyy")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value The domain name or IP address of the cloud service.
     */
    @JvmName("esjlkbgtvwrgcork")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.host = mapped
    }

    /**
     * @param value The region of the cloud service.
     */
    @JvmName("hthugrtecicyqcqa")
    public suspend fun hostRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostRegionId = mapped
    }

    /**
     * @param value The VPC associated with the cloud service.
     */
    @JvmName("ktdcdrhgjcrccgwa")
    public suspend fun hostVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostVpcId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("evaylrbmjunnncph")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the cloud service. Valid values: `Active`, `Creating` and `Deleting`.
     */
    @JvmName("wqtimvgagghgkkuv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetRouteServicesPlainArgs = GetRouteServicesPlainArgs(
        accessRegionId = accessRegionId,
        cenId = cenId ?: throw PulumiNullFieldException("cenId"),
        host = host,
        hostRegionId = hostRegionId,
        hostVpcId = hostVpcId,
        outputFile = outputFile,
        status = status,
    )
}
