@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTrafficMarkingPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrafficMarkingPolicies.
 * @property description
 * @property ids A list of Traffic Marking Policy IDs.
 * @property nameRegex A regex string to filter results by Traffic Marking Policy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource.  Valid values: `Active`, `Creating`, `Deleting`, `Updating`.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetTrafficMarkingPoliciesPlainArgs(
    public val description: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTrafficMarkingPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTrafficMarkingPoliciesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTrafficMarkingPoliciesPlainArgs.builder()
            .description(description?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrafficMarkingPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetTrafficMarkingPoliciesPlainArgsBuilder internal constructor() {
    private var description: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value
     */
    @JvmName("rhmdbdvikmoobshq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value A list of Traffic Marking Policy IDs.
     */
    @JvmName("tgdmpkjhvahwoudj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Traffic Marking Policy IDs.
     */
    @JvmName("nuucamnmqbbjmpjb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Traffic Marking Policy name.
     */
    @JvmName("kowdsesipdjyecej")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qkfcepfttqgxhjsj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource.  Valid values: `Active`, `Creating`, `Deleting`, `Updating`.
     */
    @JvmName("ytyjdllkrknrqhto")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("hhrhwtpiwplnjmln")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetTrafficMarkingPoliciesPlainArgs = GetTrafficMarkingPoliciesPlainArgs(
        description = description,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
    )
}
