@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouteTableAggregationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouteTableAggregations.
 * @property ids A list of Transit Route Table Aggregation IDs.
 * @property nameRegex A regex string to filter results by Transit Route Table Aggregation name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
 * @property transitRouteTableAggregationCidr The destination CIDR block of the aggregate route.
 * @property transitRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class GetTransitRouteTableAggregationsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouteTableAggregationCidr: String? = null,
    public val transitRouteTableId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouteTableAggregationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouteTableAggregationsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouteTableAggregationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouteTableAggregationCidr(transitRouteTableAggregationCidr?.let({ args0 -> args0 }))
            .transitRouteTableId(transitRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouteTableAggregationsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouteTableAggregationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouteTableAggregationCidr: String? = null

    private var transitRouteTableId: String? = null

    /**
     * @param value A list of Transit Route Table Aggregation IDs.
     */
    @JvmName("qjyqexseqyongugu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Route Table Aggregation IDs.
     */
    @JvmName("hqndvgujlqpydpwe")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Transit Route Table Aggregation name.
     */
    @JvmName("hbqlbvluqdxphtlj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dsyrsrpekknasklf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of Transit Route Table Aggregation. Valid Values: `AllConfigured`, `Configuring`, `ConfigFailed`, `PartialConfigured`, `Deleting`.
     */
    @JvmName("esjqmpkwevpjedkh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The destination CIDR block of the aggregate route.
     */
    @JvmName("cgcholnxvulkvahn")
    public suspend fun transitRouteTableAggregationCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouteTableAggregationCidr = mapped
    }

    /**
     * @param value The ID of the route table of the Enterprise Edition transit router.
     */
    @JvmName("jgfdjhicyvicwuab")
    public suspend fun transitRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouteTableId = mapped
    }

    internal fun build(): GetTransitRouteTableAggregationsPlainArgs =
        GetTransitRouteTableAggregationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouteTableAggregationCidr = transitRouteTableAggregationCidr,
            transitRouteTableId = transitRouteTableId ?: throw PulumiNullFieldException("transitRouteTableId"),
        )
}
