@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterAvailableResources.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property supportMulticast Specifies whether to query only the zones in which the multicast feature is supported.
 */
public data class GetTransitRouterAvailableResourcesPlainArgs(
    public val outputFile: String? = null,
    public val supportMulticast: Boolean? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesPlainArgs = com.pulumi.alicloud.cen.inputs.GetTransitRouterAvailableResourcesPlainArgs.builder()
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .supportMulticast(supportMulticast?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterAvailableResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterAvailableResourcesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var supportMulticast: Boolean? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("swavlbdluhnwchkt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Specifies whether to query only the zones in which the multicast feature is supported.
     */
    @JvmName("ccahtdkplwkmxbnn")
    public suspend fun supportMulticast(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportMulticast = mapped
    }

    internal fun build(): GetTransitRouterAvailableResourcesPlainArgs =
        GetTransitRouterAvailableResourcesPlainArgs(
            outputFile = outputFile,
            supportMulticast = supportMulticast,
        )
}
