@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterCidrsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterCidrs.
 * @property ids A list of Cen Transit Router Cidr IDs.
 * @property nameRegex A regex string to filter results by Transit Router Cidr name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property transitRouterCidrId The ID of the transit router cidr.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetTransitRouterCidrsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val transitRouterCidrId: String? = null,
    public val transitRouterId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterCidrsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterCidrsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterCidrsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .transitRouterCidrId(transitRouterCidrId?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterCidrsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterCidrsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var transitRouterCidrId: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value A list of Cen Transit Router Cidr IDs.
     */
    @JvmName("gfieiwngwnbflobo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cen Transit Router Cidr IDs.
     */
    @JvmName("bhybpeaudglsxbpt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Transit Router Cidr name.
     */
    @JvmName("mpcdhvdefdsfevsn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qwvksfrmxqccmsgv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the transit router cidr.
     */
    @JvmName("oirlxdsjfdlaxpkb")
    public suspend fun transitRouterCidrId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterCidrId = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("hasejodxekuwcmtj")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetTransitRouterCidrsPlainArgs = GetTransitRouterCidrsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        transitRouterCidrId = transitRouterCidrId,
        transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
    )
}
