@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterMulticastDomainAssociations.
 * @property ids A list of Transit Router Multicast Domain Association IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceId The ID of the resource associated with the multicast domain.
 * @property resourceType The type of resource associated with the multicast domain. Valid Value: `VPC`.
 * @property status The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterMulticastDomainId The ID of the multicast domain.
 * @property vswitchId The ID of the vSwitch.
 */
public data class GetTransitRouterMulticastDomainAssociationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterMulticastDomainId: String,
    public val vswitchId: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainAssociationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceId(resourceId?.let({ args0 -> args0 }))
            .resourceType(resourceType?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.let({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId.let({ args0 -> args0 }))
            .vswitchId(vswitchId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterMulticastDomainAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterMulticastDomainAssociationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var resourceId: String? = null

    private var resourceType: String? = null

    private var status: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterMulticastDomainId: String? = null

    private var vswitchId: String? = null

    /**
     * @param value A list of Transit Router Multicast Domain Association IDs.
     */
    @JvmName("bvfraadfgmsfpgen")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Router Multicast Domain Association IDs.
     */
    @JvmName("qnushiqgitdrpqld")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kvguahygncrlfsdc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the resource associated with the multicast domain.
     */
    @JvmName("nbnrgkpobmllrwqt")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value The type of resource associated with the multicast domain. Valid Value: `VPC`.
     */
    @JvmName("ssppmqdrioixfwxc")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The status of the associated resource. Valid Value: `Associated`, `Associating`, `Dissociating`.
     */
    @JvmName("bulpgrsejmwwscgd")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the network instance connection.
     */
    @JvmName("rpjnjynfnclgokeo")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the multicast domain.
     */
    @JvmName("rbiqkoptwqvwidga")
    public suspend fun transitRouterMulticastDomainId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterMulticastDomainId = mapped
    }

    /**
     * @param value The ID of the vSwitch.
     */
    @JvmName("dcuulftuvjhrkcxm")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vswitchId = mapped
    }

    internal fun build(): GetTransitRouterMulticastDomainAssociationsPlainArgs =
        GetTransitRouterMulticastDomainAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            resourceId = resourceId,
            resourceType = resourceType,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId ?: throw
                PulumiNullFieldException("transitRouterMulticastDomainId"),
            vswitchId = vswitchId,
        )
}
