@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainMembersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterMulticastDomainMembers.
 * @property ids A list of Transit Router Multicast Domain Member IDs.
 * @property networkInterfaceId The ID of the ENI.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 */
public data class GetTransitRouterMulticastDomainMembersPlainArgs(
    public val ids: List<String>? = null,
    public val networkInterfaceId: String? = null,
    public val outputFile: String? = null,
    public val transitRouterMulticastDomainId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainMembersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainMembersPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainMembersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .networkInterfaceId(networkInterfaceId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterMulticastDomainMembersPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterMulticastDomainMembersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var networkInterfaceId: String? = null

    private var outputFile: String? = null

    private var transitRouterMulticastDomainId: String? = null

    /**
     * @param value A list of Transit Router Multicast Domain Member IDs.
     */
    @JvmName("oyknrqtkidqlmgri")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Router Multicast Domain Member IDs.
     */
    @JvmName("ggmawvodbitxreov")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the ENI.
     */
    @JvmName("djiakggaunaaivft")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("souuplmcrfjscjlg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the multicast domain to which the multicast member belongs.
     */
    @JvmName("fqkedhydvjjqxnfq")
    public suspend fun transitRouterMulticastDomainId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterMulticastDomainId = mapped
    }

    internal fun build(): GetTransitRouterMulticastDomainMembersPlainArgs =
        GetTransitRouterMulticastDomainMembersPlainArgs(
            ids = ids,
            networkInterfaceId = networkInterfaceId,
            outputFile = outputFile,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId ?: throw
                PulumiNullFieldException("transitRouterMulticastDomainId"),
        )
}
