@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterMulticastDomainPeerMembers.
 * @property ids A list of Cen Transit Router Multicast Domain Peer Member IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property peerTransitRouterMulticastDomains The IDs of the inter-region multicast domains.
 * @property resourceId The ID of the resource associated with the multicast resource.
 * @property resourceType The type of the multicast resource. Valid values:
 * * VPC: queries multicast resources by VPC.
 * * TR: queries multicast resources that are also deployed in a different region.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast member belongs.
 */
public data class GetTransitRouterMulticastDomainPeerMembersPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val peerTransitRouterMulticastDomains: List<String>? = null,
    public val resourceId: String? = null,
    public val resourceType: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterMulticastDomainId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainPeerMembersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .peerTransitRouterMulticastDomains(
                peerTransitRouterMulticastDomains?.let({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .resourceId(resourceId?.let({ args0 -> args0 }))
            .resourceType(resourceType?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.let({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterMulticastDomainPeerMembersPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterMulticastDomainPeerMembersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var peerTransitRouterMulticastDomains: List<String>? = null

    private var resourceId: String? = null

    private var resourceType: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterMulticastDomainId: String? = null

    /**
     * @param value A list of Cen Transit Router Multicast Domain Peer Member IDs.
     */
    @JvmName("skducykgxljbnhvg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cen Transit Router Multicast Domain Peer Member IDs.
     */
    @JvmName("hcxedsdqieggihsh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("byasxbeuiokvxyuw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The IDs of the inter-region multicast domains.
     */
    @JvmName("oqohbpywwikdfyyf")
    public suspend fun peerTransitRouterMulticastDomains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.peerTransitRouterMulticastDomains = mapped
    }

    /**
     * @param values The IDs of the inter-region multicast domains.
     */
    @JvmName("xhsbpckyqywaaaui")
    public suspend fun peerTransitRouterMulticastDomains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peerTransitRouterMulticastDomains = mapped
    }

    /**
     * @param value The ID of the resource associated with the multicast resource.
     */
    @JvmName("ekewgjspiwdggskj")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the multicast resource. Valid values:
     * * VPC: queries multicast resources by VPC.
     * * TR: queries multicast resources that are also deployed in a different region.
     */
    @JvmName("igshyilvveqkdfva")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    /**
     * @param value The ID of the network instance connection.
     */
    @JvmName("mpfitftwfsqtvgnj")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the multicast domain to which the multicast member belongs.
     */
    @JvmName("dicfnioohyhcoonc")
    public suspend fun transitRouterMulticastDomainId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterMulticastDomainId = mapped
    }

    internal fun build(): GetTransitRouterMulticastDomainPeerMembersPlainArgs =
        GetTransitRouterMulticastDomainPeerMembersPlainArgs(
            ids = ids,
            outputFile = outputFile,
            peerTransitRouterMulticastDomains = peerTransitRouterMulticastDomains,
            resourceId = resourceId,
            resourceType = resourceType,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId ?: throw
                PulumiNullFieldException("transitRouterMulticastDomainId"),
        )
}
