@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainSourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterMulticastDomainSources.
 * @property ids A list of the multicast domain IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property transitRouterMulticastDomainId The ID of the multicast domain to which the multicast source belongs.
 */
public data class GetTransitRouterMulticastDomainSourcesPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val transitRouterMulticastDomainId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainSourcesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainSourcesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainSourcesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterMulticastDomainSourcesPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterMulticastDomainSourcesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var transitRouterMulticastDomainId: String? = null

    /**
     * @param value A list of the multicast domain IDs.
     */
    @JvmName("wustixkicjmjgmat")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of the multicast domain IDs.
     */
    @JvmName("jieetufnwkcewexb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("pdjmjnjfnklyvaxd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the multicast domain to which the multicast source belongs.
     */
    @JvmName("ksbpsvgjpcawtlqr")
    public suspend fun transitRouterMulticastDomainId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterMulticastDomainId = mapped
    }

    internal fun build(): GetTransitRouterMulticastDomainSourcesPlainArgs =
        GetTransitRouterMulticastDomainSourcesPlainArgs(
            ids = ids,
            outputFile = outputFile,
            transitRouterMulticastDomainId = transitRouterMulticastDomainId ?: throw
                PulumiNullFieldException("transitRouterMulticastDomainId"),
        )
}
