@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterMulticastDomains.
 * @property ids A list of Transit Router Multicast Domain IDs.
 * @property nameRegex A regex string to filter results by Transit Router Multicast Domain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the multicast domain. Valid Value: `Active`.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterMulticastDomainId The ID of the multicast domain.
 */
public data class GetTransitRouterMulticastDomainsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
    public val transitRouterMulticastDomainId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterMulticastDomainsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 }))
            .transitRouterMulticastDomainId(transitRouterMulticastDomainId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterMulticastDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterMulticastDomainsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    private var transitRouterMulticastDomainId: String? = null

    /**
     * @param value A list of Transit Router Multicast Domain IDs.
     */
    @JvmName("phuqlrrudipdfbis")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Router Multicast Domain IDs.
     */
    @JvmName("xcqwgkndkpuqsbyw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Transit Router Multicast Domain name.
     */
    @JvmName("miqqxekybpesurvw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sehpkuobynpegews")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the multicast domain. Valid Value: `Active`.
     */
    @JvmName("pugpggjwqhamnxwq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("fyrrjturcynuknaw")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the multicast domain.
     */
    @JvmName("hlscwbptaosomnbp")
    public suspend fun transitRouterMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterMulticastDomainId = mapped
    }

    internal fun build(): GetTransitRouterMulticastDomainsPlainArgs =
        GetTransitRouterMulticastDomainsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
            transitRouterMulticastDomainId = transitRouterMulticastDomainId,
        )
}
