@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterPeerAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterPeerAttachments.
 * @property cenId ID of the CEN instance.
 * @property ids A list of CEN Transit Router peer attachments IDs.
 * @property nameRegex A regex string to filter CEN Transit Router peer attachments by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
 * @property transitRouterAttachmentId The ID of CEN Transit Router peer attachments.
 * @property transitRouterId The ID of transit router.
 */
public data class GetTransitRouterPeerAttachmentsPlainArgs(
    public val cenId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterPeerAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterPeerAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterPeerAttachmentsPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterPeerAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterPeerAttachmentsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value ID of the CEN instance.
     */
    @JvmName("avbrxmwkncfiebju")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of CEN Transit Router peer attachments IDs.
     */
    @JvmName("uyfjeipbvddtmtri")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN Transit Router peer attachments IDs.
     */
    @JvmName("fnhcnxwwjymuvbwn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter CEN Transit Router peer attachments by name.
     */
    @JvmName("brdurxmpwverdxsh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ebkxdnhwukegihpf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of CEN Transit Router peer attachment. Valid values `Attached`, `Attaching` and `Detaching`.
     */
    @JvmName("pfnmfkjaeuadgndr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of CEN Transit Router peer attachments.
     */
    @JvmName("ewwumumvcwaiqbdf")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of transit router.
     */
    @JvmName("erwlmowlkqudcxkc")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetTransitRouterPeerAttachmentsPlainArgs =
        GetTransitRouterPeerAttachmentsPlainArgs(
            cenId = cenId ?: throw PulumiNullFieldException("cenId"),
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterId = transitRouterId,
        )
}
