@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterPrefixListAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterPrefixListAssociations.
 * @property ids A list of Cen Transit Router Prefix List Association IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property ownerUid The ID of the Alibaba Cloud account to which the prefix list belongs.
 * @property pageNumber
 * @property pageSize
 * @property prefixListId The ID of the prefix list.
 * @property status The status of the prefix list. Valid Value: `Active`, `Updating`.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterTableId The ID of the route table of the transit router.
 */
public data class GetTransitRouterPrefixListAssociationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val ownerUid: Int? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val prefixListId: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
    public val transitRouterTableId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterPrefixListAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterPrefixListAssociationsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterPrefixListAssociationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .ownerUid(ownerUid?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .prefixListId(prefixListId?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 }))
            .transitRouterTableId(transitRouterTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterPrefixListAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterPrefixListAssociationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var ownerUid: Int? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var prefixListId: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    private var transitRouterTableId: String? = null

    /**
     * @param value A list of Cen Transit Router Prefix List Association IDs.
     */
    @JvmName("skcxiqacapbuctrv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Cen Transit Router Prefix List Association IDs.
     */
    @JvmName("pdpwyxqbsygsxufj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("odewuqtdmksxqive")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Alibaba Cloud account to which the prefix list belongs.
     */
    @JvmName("xradosdbwjvqesco")
    public suspend fun ownerUid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ownerUid = mapped
    }

    /**
     * @param value
     */
    @JvmName("xshdfonpcxuqufbu")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("emdrtnrbjqqalkow")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The ID of the prefix list.
     */
    @JvmName("ccjekfnfqmwvcomp")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.prefixListId = mapped
    }

    /**
     * @param value The status of the prefix list. Valid Value: `Active`, `Updating`.
     */
    @JvmName("bcxtbskdwdgnnxre")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("ykadqedjlasxxxax")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the route table of the transit router.
     */
    @JvmName("nrnjvjsanvjtfbom")
    public suspend fun transitRouterTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterTableId = mapped
    }

    internal fun build(): GetTransitRouterPrefixListAssociationsPlainArgs =
        GetTransitRouterPrefixListAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            ownerUid = ownerUid,
            pageNumber = pageNumber,
            pageSize = pageSize,
            prefixListId = prefixListId,
            status = status,
            transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
            transitRouterTableId = transitRouterTableId ?: throw
                PulumiNullFieldException("transitRouterTableId"),
        )
}
