@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteEntriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterRouteEntries.
 * @property ids A list of CEN Transit Router Route Entry IDs.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status
 * @property transitRouterRouteEntryIds A list of ID of the cen transit router route entry.
 * @property transitRouterRouteEntryNames A list of name of the cen transit router route entry.
 * @property transitRouterRouteEntryStatus The status of the resource.Valid values `Creating`, `Active` and `Deleting`.
 * @property transitRouterRouteTableId ID of the CEN Transit Router Route Table.
 */
public data class GetTransitRouterRouteEntriesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterRouteEntryIds: List<String>? = null,
    public val transitRouterRouteEntryNames: List<String>? = null,
    public val transitRouterRouteEntryStatus: String? = null,
    public val transitRouterRouteTableId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteEntriesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteEntriesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteEntriesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterRouteEntryIds(
                transitRouterRouteEntryIds?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .transitRouterRouteEntryNames(
                transitRouterRouteEntryNames?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .transitRouterRouteEntryStatus(transitRouterRouteEntryStatus?.let({ args0 -> args0 }))
            .transitRouterRouteTableId(transitRouterRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterRouteEntriesPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterRouteEntriesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterRouteEntryIds: List<String>? = null

    private var transitRouterRouteEntryNames: List<String>? = null

    private var transitRouterRouteEntryStatus: String? = null

    private var transitRouterRouteTableId: String? = null

    /**
     * @param value A list of CEN Transit Router Route Entry IDs.
     */
    @JvmName("ihfwcivvfkwsmymd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN Transit Router Route Entry IDs.
     */
    @JvmName("ivqkkpeolgkdpneu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("recdmpsudbvefwww")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("powrtpdqtjtxmccu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ltnrtuanifeitcty")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A list of ID of the cen transit router route entry.
     */
    @JvmName("msdhktnbwthrchpp")
    public suspend fun transitRouterRouteEntryIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteEntryIds = mapped
    }

    /**
     * @param values A list of ID of the cen transit router route entry.
     */
    @JvmName("wpfwwlsommjutaln")
    public suspend fun transitRouterRouteEntryIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteEntryIds = mapped
    }

    /**
     * @param value A list of name of the cen transit router route entry.
     */
    @JvmName("jvejongunptvpors")
    public suspend fun transitRouterRouteEntryNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteEntryNames = mapped
    }

    /**
     * @param values A list of name of the cen transit router route entry.
     */
    @JvmName("uhrpwbbonsuopkpu")
    public suspend fun transitRouterRouteEntryNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteEntryNames = mapped
    }

    /**
     * @param value The status of the resource.Valid values `Creating`, `Active` and `Deleting`.
     */
    @JvmName("bwttqlwivbbelmgp")
    public suspend fun transitRouterRouteEntryStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteEntryStatus = mapped
    }

    /**
     * @param value ID of the CEN Transit Router Route Table.
     */
    @JvmName("desbwktiygrwtbww")
    public suspend fun transitRouterRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteTableId = mapped
    }

    internal fun build(): GetTransitRouterRouteEntriesPlainArgs =
        GetTransitRouterRouteEntriesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterRouteEntryIds = transitRouterRouteEntryIds,
            transitRouterRouteEntryNames = transitRouterRouteEntryNames,
            transitRouterRouteEntryStatus = transitRouterRouteEntryStatus,
            transitRouterRouteTableId = transitRouterRouteTableId ?: throw
                PulumiNullFieldException("transitRouterRouteTableId"),
        )
}
