@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTableAssociationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterRouteTableAssociations.
 * @property ids A list of CEN Transit Router Route Table Association IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the route table, including `Active`, `Associating`, `Dissociating`.
 * @property transitRouterAttachmentId The ID of the network instance connection.
 * @property transitRouterAttachmentResourceId The ID of the next hop.
 * @property transitRouterAttachmentResourceType The type of next hop. Valid values:
 * * `VPC`: virtual private cloud (VPC)
 * * `VBR`: virtual border router (VBR)
 * * `TR`: transit router
 * * `VPN`: VPN attachment
 * @property transitRouterRouteTableId The ID of the route table of the Enterprise Edition transit router.
 */
public data class GetTransitRouterRouteTableAssociationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterAttachmentResourceId: String? = null,
    public val transitRouterAttachmentResourceType: String? = null,
    public val transitRouterRouteTableId: String? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTableAssociationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTableAssociationsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTableAssociationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.let({ args0 -> args0 }))
            .transitRouterAttachmentResourceId(transitRouterAttachmentResourceId?.let({ args0 -> args0 }))
            .transitRouterAttachmentResourceType(transitRouterAttachmentResourceType?.let({ args0 -> args0 }))
            .transitRouterRouteTableId(transitRouterRouteTableId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterRouteTableAssociationsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterRouteTableAssociationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterAttachmentResourceId: String? = null

    private var transitRouterAttachmentResourceType: String? = null

    private var transitRouterRouteTableId: String? = null

    /**
     * @param value A list of CEN Transit Router Route Table Association IDs.
     */
    @JvmName("vydutenfkpvjnbxy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN Transit Router Route Table Association IDs.
     */
    @JvmName("rnklfscmjftlujye")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ftvxgorvucbyjawv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the route table, including `Active`, `Associating`, `Dissociating`.
     */
    @JvmName("uqfafhqbisflnrxx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the network instance connection.
     */
    @JvmName("ucsblrnrfhwbjwhe")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the next hop.
     */
    @JvmName("jqltmegrkllcyxoy")
    public suspend fun transitRouterAttachmentResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentResourceId = mapped
    }

    /**
     * @param value The type of next hop. Valid values:
     * * `VPC`: virtual private cloud (VPC)
     * * `VBR`: virtual border router (VBR)
     * * `TR`: transit router
     * * `VPN`: VPN attachment
     */
    @JvmName("jofuublhuydocmmb")
    public suspend fun transitRouterAttachmentResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentResourceType = mapped
    }

    /**
     * @param value The ID of the route table of the Enterprise Edition transit router.
     */
    @JvmName("xsytfklpmbxqomwj")
    public suspend fun transitRouterRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteTableId = mapped
    }

    internal fun build(): GetTransitRouterRouteTableAssociationsPlainArgs =
        GetTransitRouterRouteTableAssociationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterAttachmentResourceId = transitRouterAttachmentResourceId,
            transitRouterAttachmentResourceType = transitRouterAttachmentResourceType,
            transitRouterRouteTableId = transitRouterRouteTableId,
        )
}
