@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablePropagationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterRouteTablePropagations.
 * @property ids A list of CEN Transit Router Route Table Association IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the route table, including `Active`, `Enabling`, `Disabling`, `Deleted`.
 * @property transitRouterRouteTableId ID of the route table of the VPC or VBR.
 */
public data class GetTransitRouterRouteTablePropagationsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterRouteTableId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablePropagationsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablePropagationsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablePropagationsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterRouteTableId(transitRouterRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterRouteTablePropagationsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterRouteTablePropagationsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterRouteTableId: String? = null

    /**
     * @param value A list of CEN Transit Router Route Table Association IDs.
     */
    @JvmName("ffbdvqyqbiprggik")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN Transit Router Route Table Association IDs.
     */
    @JvmName("svmhkeyyggktchai")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("twfsfkienvqeibhl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the route table, including `Active`, `Enabling`, `Disabling`, `Deleted`.
     */
    @JvmName("rdijpawbaokgqula")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value ID of the route table of the VPC or VBR.
     */
    @JvmName("mpbdkcososafvtxw")
    public suspend fun transitRouterRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteTableId = mapped
    }

    internal fun build(): GetTransitRouterRouteTablePropagationsPlainArgs =
        GetTransitRouterRouteTablePropagationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterRouteTableId = transitRouterRouteTableId ?: throw
                PulumiNullFieldException("transitRouterRouteTableId"),
        )
}
