@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterRouteTables.
 * @property ids A list of CEN Transit Router Route Table IDs.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status
 * @property transitRouterId ID of the CEN Transit Router Route Table.
 * @property transitRouterRouteTableIds A list of ID of the CEN Transit Router Route Table.
 * @property transitRouterRouteTableNames A list of name of the CEN Transit Router Route Table.
 * @property transitRouterRouteTableStatus The status of the transit router route table to query.
 */
public data class GetTransitRouterRouteTablesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String,
    public val transitRouterRouteTableIds: List<String>? = null,
    public val transitRouterRouteTableNames: List<String>? = null,
    public val transitRouterRouteTableStatus: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablesPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterRouteTablesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId.let({ args0 -> args0 }))
            .transitRouterRouteTableIds(
                transitRouterRouteTableIds?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .transitRouterRouteTableNames(
                transitRouterRouteTableNames?.let({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .transitRouterRouteTableStatus(transitRouterRouteTableStatus?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterRouteTablesPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterRouteTablesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    private var transitRouterRouteTableIds: List<String>? = null

    private var transitRouterRouteTableNames: List<String>? = null

    private var transitRouterRouteTableStatus: String? = null

    /**
     * @param value A list of CEN Transit Router Route Table IDs.
     */
    @JvmName("fvmhscvcfbhubllf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of CEN Transit Router Route Table IDs.
     */
    @JvmName("fmpbkenjwpkacqdl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("rtkypoovuhhyrhmj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("plohrkeotfjrkltd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("pmcfxgngjnjusxjb")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value ID of the CEN Transit Router Route Table.
     */
    @JvmName("rptidslqjsgnmupf")
    public suspend fun transitRouterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    /**
     * @param value A list of ID of the CEN Transit Router Route Table.
     */
    @JvmName("giswrylmhusjvmwt")
    public suspend fun transitRouterRouteTableIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteTableIds = mapped
    }

    /**
     * @param values A list of ID of the CEN Transit Router Route Table.
     */
    @JvmName("jpfljwuplnewllds")
    public suspend fun transitRouterRouteTableIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteTableIds = mapped
    }

    /**
     * @param value A list of name of the CEN Transit Router Route Table.
     */
    @JvmName("gqevbcpsbetakqxe")
    public suspend fun transitRouterRouteTableNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteTableNames = mapped
    }

    /**
     * @param values A list of name of the CEN Transit Router Route Table.
     */
    @JvmName("yuifdsojfsguqwkw")
    public suspend fun transitRouterRouteTableNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterRouteTableNames = mapped
    }

    /**
     * @param value The status of the transit router route table to query.
     */
    @JvmName("bxuxmlovllmcnikh")
    public suspend fun transitRouterRouteTableStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterRouteTableStatus = mapped
    }

    internal fun build(): GetTransitRouterRouteTablesPlainArgs = GetTransitRouterRouteTablesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        transitRouterId = transitRouterId ?: throw PulumiNullFieldException("transitRouterId"),
        transitRouterRouteTableIds = transitRouterRouteTableIds,
        transitRouterRouteTableNames = transitRouterRouteTableNames,
        transitRouterRouteTableStatus = transitRouterRouteTableStatus,
    )
}
