@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterService.
 * @property enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
 * > **NOTE:** Setting `enable = "On"` to open the CEN Transit Router Service that means you have read and agreed the [CEN Terms of Service](https://help.aliyun.com/document_detail/66667.html). The service can not closed once it is opened.
 */
public data class GetTransitRouterServicePlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterServicePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterServicePlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterServicePlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterServicePlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterServicePlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the CEN Transit Router Service that means you have read and agreed the [CEN Terms of Service](https://help.aliyun.com/document_detail/66667.html). The service can not closed once it is opened.
     */
    @JvmName("vmmpmjjbuljsvjli")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetTransitRouterServicePlainArgs = GetTransitRouterServicePlainArgs(
        enable = enable,
    )
}
