@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterVbrAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterVbrAttachments.
 * @property cenId ID of the CEN instance.
 * @property ids A list of resource id. The element value is same as `transit_router_id`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
 * @property transitRouterId ID of the transit router.
 */
public data class GetTransitRouterVbrAttachmentsPlainArgs(
    public val cenId: String,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterVbrAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterVbrAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterVbrAttachmentsPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterVbrAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterVbrAttachmentsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value ID of the CEN instance.
     */
    @JvmName("tyumneuixoobiyyq")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of resource id. The element value is same as `transit_router_id`.
     */
    @JvmName("licyhahylrhtmnxi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of resource id. The element value is same as `transit_router_id`.
     */
    @JvmName("cvmloktvpnjcypvp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("scaexwvmqinvakgy")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values `Attached`, `Attaching` and `Detaching`.
     */
    @JvmName("rtquiebixmltmudh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value ID of the transit router.
     */
    @JvmName("dtulgxfnraftpkcq")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetTransitRouterVbrAttachmentsPlainArgs =
        GetTransitRouterVbrAttachmentsPlainArgs(
            cenId = cenId ?: throw PulumiNullFieldException("cenId"),
            ids = ids,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
        )
}
