@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterVpcAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterVpcAttachments.
 * @property cenId The ID of the CEN instance.
 * @property ids A list of Transit Router VPC Attachment IDs.
 * @property nameRegex A regex string to filter results by Transit Router VPC Attachment name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
 * @property transitRouterAttachmentId The ID of the Transit Router VPC Attachment.
 * @property transitRouterId The ID of the transit router.
 * @property vpcId The ID of the VPC.
 */
public data class GetTransitRouterVpcAttachmentsPlainArgs(
    public val cenId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterAttachmentId: String? = null,
    public val transitRouterId: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterVpcAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterVpcAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterVpcAttachmentsPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterAttachmentId(transitRouterAttachmentId?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterVpcAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterVpcAttachmentsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterAttachmentId: String? = null

    private var transitRouterId: String? = null

    private var vpcId: String? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("cbdtoajsncidbysw")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of Transit Router VPC Attachment IDs.
     */
    @JvmName("loewpnwqqwnnwwwc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Router VPC Attachment IDs.
     */
    @JvmName("mgarpltwcevrwejt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Transit Router VPC Attachment name.
     */
    @JvmName("xhsthleguejkwbde")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xxakuiepuuermnnj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the Transit Router VPC Attachment. Valid Values: `Attached`, `Attaching`, `Detaching`.
     */
    @JvmName("rxseihfymcbjhrgp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the Transit Router VPC Attachment.
     */
    @JvmName("qfpoayamgvaotnmj")
    public suspend fun transitRouterAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterAttachmentId = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("eardkxoplndtxmqg")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("khkmyjovutredmth")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetTransitRouterVpcAttachmentsPlainArgs =
        GetTransitRouterVpcAttachmentsPlainArgs(
            cenId = cenId ?: throw PulumiNullFieldException("cenId"),
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterAttachmentId = transitRouterAttachmentId,
            transitRouterId = transitRouterId,
            vpcId = vpcId,
        )
}
