@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRouterVpnAttachmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouterVpnAttachments.
 * @property cenId The id of the cen.
 * @property ids A list of Transit Router Vpn Attachment IDs.
 * @property nameRegex
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The Status of Transit Router Vpn Attachment. Valid Value: `Attached`, `Attaching`, `Detaching`.
 * @property transitRouterId The ID of the forwarding router instance.
 */
public data class GetTransitRouterVpnAttachmentsPlainArgs(
    public val cenId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRouterVpnAttachmentsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRouterVpnAttachmentsPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRouterVpnAttachmentsPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTransitRouterVpnAttachmentsPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRouterVpnAttachmentsPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    /**
     * @param value The id of the cen.
     */
    @JvmName("ylcidkmcsmbvndrr")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of Transit Router Vpn Attachment IDs.
     */
    @JvmName("yakbllklmcjhcrgu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Transit Router Vpn Attachment IDs.
     */
    @JvmName("rlajixucsijjmela")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("cioecugnkynmeewh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qeamhelqpacljxme")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Status of Transit Router Vpn Attachment. Valid Value: `Attached`, `Attaching`, `Detaching`.
     */
    @JvmName("mlbrfpgdlmmjunww")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the forwarding router instance.
     */
    @JvmName("qrdcglnvvvwrhvcb")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    internal fun build(): GetTransitRouterVpnAttachmentsPlainArgs =
        GetTransitRouterVpnAttachmentsPlainArgs(
            cenId = cenId ?: throw PulumiNullFieldException("cenId"),
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            transitRouterId = transitRouterId,
        )
}
