@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetTransitRoutersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTransitRouters.
 * @property cenId The ID of the CEN instance.
 * @property ids A list of resource id. The element value is same as <cen_id>:<transit_router_id>`.
 * @property nameRegex A regex string to filter CEN Transit Routers by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
 * @property transitRouterId The ID of the transit router.
 * @property transitRouterIds A list of ID of the transit router.
 */
public data class GetTransitRoutersPlainArgs(
    public val cenId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val transitRouterId: String? = null,
    public val transitRouterIds: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetTransitRoutersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetTransitRoutersPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetTransitRoutersPlainArgs.builder()
            .cenId(cenId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .transitRouterId(transitRouterId?.let({ args0 -> args0 }))
            .transitRouterIds(transitRouterIds?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetTransitRoutersPlainArgs].
 */
@PulumiTagMarker
public class GetTransitRoutersPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var transitRouterId: String? = null

    private var transitRouterIds: List<String>? = null

    /**
     * @param value The ID of the CEN instance.
     */
    @JvmName("txxcealwgqbmnppd")
    public suspend fun cenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value A list of resource id. The element value is same as <cen_id>:<transit_router_id>`.
     */
    @JvmName("lkmfhpmcaapquynu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of resource id. The element value is same as <cen_id>:<transit_router_id>`.
     */
    @JvmName("gtbvkgyqnqsnwrnl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter CEN Transit Routers by name.
     */
    @JvmName("hrcwpohkkcnqixiu")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qgnjhstecipgnnpg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values `Active`, `Creating`, `Deleting` and `Updating`.
     */
    @JvmName("dwgmtdyrhqhscfam")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the transit router.
     */
    @JvmName("dojrccqjufawkynh")
    public suspend fun transitRouterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterId = mapped
    }

    /**
     * @param value A list of ID of the transit router.
     */
    @JvmName("mmffktbxjwwvmnbi")
    public suspend fun transitRouterIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitRouterIds = mapped
    }

    /**
     * @param values A list of ID of the transit router.
     */
    @JvmName("qkatnilnbelngywl")
    public suspend fun transitRouterIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitRouterIds = mapped
    }

    internal fun build(): GetTransitRoutersPlainArgs = GetTransitRoutersPlainArgs(
        cenId = cenId ?: throw PulumiNullFieldException("cenId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        transitRouterId = transitRouterId,
        transitRouterIds = transitRouterIds,
    )
}
