@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.GetVbrHealthChecksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVbrHealthChecks.
 * @property cenId The ID of the Cloud Enterprise Network (CEN) instance.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vbrInstanceId The ID of the VBR instance.
 * @property vbrInstanceOwnerId The User ID (UID) of the account to which the VBR instance belongs.
 * @property vbrInstanceRegionId The ID of the region where the VBR instance is deployed.
 */
public data class GetVbrHealthChecksPlainArgs(
    public val cenId: String? = null,
    public val outputFile: String? = null,
    public val vbrInstanceId: String? = null,
    public val vbrInstanceOwnerId: Int? = null,
    public val vbrInstanceRegionId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.GetVbrHealthChecksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.GetVbrHealthChecksPlainArgs =
        com.pulumi.alicloud.cen.inputs.GetVbrHealthChecksPlainArgs.builder()
            .cenId(cenId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vbrInstanceId(vbrInstanceId?.let({ args0 -> args0 }))
            .vbrInstanceOwnerId(vbrInstanceOwnerId?.let({ args0 -> args0 }))
            .vbrInstanceRegionId(vbrInstanceRegionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVbrHealthChecksPlainArgs].
 */
@PulumiTagMarker
public class GetVbrHealthChecksPlainArgsBuilder internal constructor() {
    private var cenId: String? = null

    private var outputFile: String? = null

    private var vbrInstanceId: String? = null

    private var vbrInstanceOwnerId: Int? = null

    private var vbrInstanceRegionId: String? = null

    /**
     * @param value The ID of the Cloud Enterprise Network (CEN) instance.
     */
    @JvmName("xjscmosbqmywphal")
    public suspend fun cenId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cenId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rfncskvegpxdhaea")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the VBR instance.
     */
    @JvmName("nxuosmifmjjaiyuj")
    public suspend fun vbrInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vbrInstanceId = mapped
    }

    /**
     * @param value The User ID (UID) of the account to which the VBR instance belongs.
     */
    @JvmName("rrxhyjsikesvasrp")
    public suspend fun vbrInstanceOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vbrInstanceOwnerId = mapped
    }

    /**
     * @param value The ID of the region where the VBR instance is deployed.
     */
    @JvmName("fejgpjpbnpxfiyce")
    public suspend fun vbrInstanceRegionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vbrInstanceRegionId = mapped
    }

    internal fun build(): GetVbrHealthChecksPlainArgs = GetVbrHealthChecksPlainArgs(
        cenId = cenId,
        outputFile = outputFile,
        vbrInstanceId = vbrInstanceId,
        vbrInstanceOwnerId = vbrInstanceOwnerId,
        vbrInstanceRegionId = vbrInstanceRegionId ?: throw PulumiNullFieldException("vbrInstanceRegionId"),
    )
}
