@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vswitchId The VSwitch id of attachment.
 * @property zoneId The zone Id of VSwitch.
 */
public data class TransitRouterVpcAttachmentZoneMappingArgs(
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs =
        com.pulumi.alicloud.cen.inputs.TransitRouterVpcAttachmentZoneMappingArgs.builder()
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterVpcAttachmentZoneMappingArgs].
 */
@PulumiTagMarker
public class TransitRouterVpcAttachmentZoneMappingArgsBuilder internal constructor() {
    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The VSwitch id of attachment.
     */
    @JvmName("fomimeexkbhfuvdx")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone Id of VSwitch.
     */
    @JvmName("bbcoaaynnlibxlwv")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The VSwitch id of attachment.
     */
    @JvmName("tefpjaigylggphwd")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone Id of VSwitch.
     */
    @JvmName("wsiredcyhnhlerbe")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): TransitRouterVpcAttachmentZoneMappingArgs =
        TransitRouterVpcAttachmentZoneMappingArgs(
            vswitchId = vswitchId,
            zoneId = zoneId,
        )
}
