@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.inputs

import com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property zoneId The id of the zone.
 */
public data class TransitRouterVpnAttachmentZoneArgs(
    public val zoneId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs> {
    override fun toJava(): com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs =
        com.pulumi.alicloud.cen.inputs.TransitRouterVpnAttachmentZoneArgs.builder()
            .zoneId(zoneId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitRouterVpnAttachmentZoneArgs].
 */
@PulumiTagMarker
public class TransitRouterVpnAttachmentZoneArgsBuilder internal constructor() {
    private var zoneId: Output<String>? = null

    /**
     * @param value The id of the zone.
     */
    @JvmName("bhrngxbcrifvpumx")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The id of the zone.
     */
    @JvmName("hpkgxsnptvfwlfnp")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): TransitRouterVpnAttachmentZoneArgs = TransitRouterVpnAttachmentZoneArgs(
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
