@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidthLimit The bandwidth limit configured for the interconnected regions communication.
 * @property instanceId ID of the CEN instance.
 * @property localRegionId ID of local region.
 * @property oppositeRegionId ID of opposite region.
 * @property status Status of the CEN Bandwidth Limit, including "Active" and "Modifying".
 */
public data class GetBandwidthLimitsLimit(
    public val bandwidthLimit: Int,
    public val instanceId: String,
    public val localRegionId: String,
    public val oppositeRegionId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetBandwidthLimitsLimit): GetBandwidthLimitsLimit = GetBandwidthLimitsLimit(
            bandwidthLimit = javaType.bandwidthLimit(),
            instanceId = javaType.instanceId(),
            localRegionId = javaType.localRegionId(),
            oppositeRegionId = javaType.oppositeRegionId(),
            status = javaType.status(),
        )
    }
}
