@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBandwidthLimits.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceIds
 * @property limits A list of CEN Bandwidth Limits. Each element contains the following attributes:
 * @property outputFile
 */
public data class GetBandwidthLimitsResult(
    public val id: String,
    public val instanceIds: List<String>? = null,
    public val limits: List<GetBandwidthLimitsLimit>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetBandwidthLimitsResult): GetBandwidthLimitsResult = GetBandwidthLimitsResult(
            id = javaType.id(),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthLimitsLimit.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
