@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth The bandwidth in Mbps of the CEN bandwidth package.
 * @property bandwidthPackageChargeType The billing method, including `POSTPAY` and `PREPAY`.
 * @property businessStatus Status of the CEN Bandwidth Package, including `Normal`, `FinancialLocked` and `SecurityLocked`.
 * @property cenBandwidthPackageId The ID of the bandwidth package.
 * @property cenBandwidthPackageName The name of the bandwidth package.
 * @property cenIds The list of CEN instances that are associated with the bandwidth package.
 * @property description Description of the CEN Bandwidth Package.
 * @property expiredTime
 * @property geographicRegionAId Region ID of the interconnected regions.
 * @property geographicRegionBId Region ID of the interconnected regions.
 * @property geographicSpanId The area ID of the cross-area connection.
 * @property hasReservationData Indicates whether renewal data is involved.
 * @property id ID of the CEN Bandwidth Package.
 * @property instanceId ID of a CEN instance.
 * @property isCrossBorder Indicates whether the bandwidth package is a cross-border bandwidth package.
 * @property name Name of the CEN Bandwidth Package.
 * @property paymentType The billing method of the bandwidth package.
 * @property reservationActiveTime The expiration time of the temporary upgrade.
 * @property reservationBandwidth The restored bandwidth after the temporary upgrade.
 * @property reservationInternetChargeType The billing method after the configuration change.
 * @property reservationOrderType The type of the configuration change.
 * @property status Status of the CEN Bandwidth Package in CEN instance, Valid value: `Idle` and `InUse`.
 */
public data class GetBandwidthPackagesPackage(
    public val bandwidth: Int,
    public val bandwidthPackageChargeType: String,
    public val businessStatus: String,
    public val cenBandwidthPackageId: String,
    public val cenBandwidthPackageName: String,
    public val cenIds: List<String>,
    public val description: String,
    public val expiredTime: String,
    public val geographicRegionAId: String,
    public val geographicRegionBId: String,
    public val geographicSpanId: String,
    public val hasReservationData: String,
    public val id: String,
    public val instanceId: String,
    public val isCrossBorder: Boolean,
    public val name: String,
    public val paymentType: String,
    public val reservationActiveTime: String,
    public val reservationBandwidth: String,
    public val reservationInternetChargeType: String,
    public val reservationOrderType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetBandwidthPackagesPackage): GetBandwidthPackagesPackage = GetBandwidthPackagesPackage(
            bandwidth = javaType.bandwidth(),
            bandwidthPackageChargeType = javaType.bandwidthPackageChargeType(),
            businessStatus = javaType.businessStatus(),
            cenBandwidthPackageId = javaType.cenBandwidthPackageId(),
            cenBandwidthPackageName = javaType.cenBandwidthPackageName(),
            cenIds = javaType.cenIds().map({ args0 -> args0 }),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            geographicRegionAId = javaType.geographicRegionAId(),
            geographicRegionBId = javaType.geographicRegionBId(),
            geographicSpanId = javaType.geographicSpanId(),
            hasReservationData = javaType.hasReservationData(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            isCrossBorder = javaType.isCrossBorder(),
            name = javaType.name(),
            paymentType = javaType.paymentType(),
            reservationActiveTime = javaType.reservationActiveTime(),
            reservationBandwidth = javaType.reservationBandwidth(),
            reservationInternetChargeType = javaType.reservationInternetChargeType(),
            reservationOrderType = javaType.reservationOrderType(),
            status = javaType.status(),
        )
    }
}
