@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBandwidthPackages.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of specific CEN Bandwidth Package IDs.
 * @property includeReservationData
 * @property instanceId The ID of the CEN instance that are associated with the bandwidth package.
 * @property nameRegex
 * @property names (Available in 1.98.0+) - A list of CEN Bandwidth Package Names.
 * @property outputFile
 * @property packages A list of CEN bandwidth package. Each element contains the following attributes:
 * @property status Status of the CEN Bandwidth Package in CEN instance, including `Idle` and `InUse`.
 */
public data class GetBandwidthPackagesResult(
    public val id: String,
    public val ids: List<String>,
    public val includeReservationData: Boolean? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val packages: List<GetBandwidthPackagesPackage>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetBandwidthPackagesResult): GetBandwidthPackagesResult = GetBandwidthPackagesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            includeReservationData = javaType.includeReservationData().map({ args0 -> args0 }).orElse(null),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            packages = javaType.packages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetBandwidthPackagesPackage.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
