@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cenId The ID of the CEN instance.
 * @property childInstanceRouteTableId The first ID of the resource
 * @property destinationCidrBlock DestinationCidrBlock
 * @property id The ID of the resource. The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
 * @property serviceType ServiceType
 * @property status The status of the resource
 * @property transitRouterAttachmentId TransitRouterAttachmentId
 */
public data class GetChildInstanceRouteEntryToAttachmentsAttachment(
    public val cenId: String,
    public val childInstanceRouteTableId: String,
    public val destinationCidrBlock: String,
    public val id: String,
    public val serviceType: String,
    public val status: String,
    public val transitRouterAttachmentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetChildInstanceRouteEntryToAttachmentsAttachment): GetChildInstanceRouteEntryToAttachmentsAttachment =
            GetChildInstanceRouteEntryToAttachmentsAttachment(
                cenId = javaType.cenId(),
                childInstanceRouteTableId = javaType.childInstanceRouteTableId(),
                destinationCidrBlock = javaType.destinationCidrBlock(),
                id = javaType.id(),
                serviceType = javaType.serviceType(),
                status = javaType.status(),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            )
    }
}
