@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getChildInstanceRouteEntryToAttachments.
 * @property attachments A list of Child Instance Route Entry To Attachment Entries. Each element contains the following attributes:
 * @property cenId The ID of the CEN instance.
 * @property childInstanceRouteTableId The first ID of the resource
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Limit search to a list of specific IDs.The value is formulated as `<cen_id>:<child_instance_route_table_id>:<transit_router_attachment_id>:<destination_cidr_block>`.
 * @property outputFile
 * @property serviceType ServiceType
 * @property transitRouterAttachmentId TransitRouterAttachmentId
 */
public data class GetChildInstanceRouteEntryToAttachmentsResult(
    public val attachments: List<GetChildInstanceRouteEntryToAttachmentsAttachment>,
    public val cenId: String? = null,
    public val childInstanceRouteTableId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val serviceType: String? = null,
    public val transitRouterAttachmentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetChildInstanceRouteEntryToAttachmentsResult): GetChildInstanceRouteEntryToAttachmentsResult =
            GetChildInstanceRouteEntryToAttachmentsResult(
                attachments = javaType.attachments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.cen.kotlin.outputs.GetChildInstanceRouteEntryToAttachmentsAttachment.Companion.toKotlin(args0)
                    })
                }),
                cenId = javaType.cenId().map({ args0 -> args0 }).orElse(null),
                childInstanceRouteTableId = javaType.childInstanceRouteTableId(),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
                serviceType = javaType.serviceType().map({ args0 -> args0 }).orElse(null),
                transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            )
    }
}
