@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cenId The ID of the CEN Instance.
 * @property description The description of flowlog.
 * @property flowLogId ID of the CEN flow log.
 * @property flowLogName The name of flowlog.
 * @property id ID of the CEN flow log.
 * @property logStoreName The name of the log store which is in the  `project_name` SLS project.
 * @property projectName The name of the SLS project.
 * @property status The status of flowlog. Valid values: ["Active", "Inactive"]. Default to "Active".
 */
public data class GetFlowlogsFlowlog(
    public val cenId: String,
    public val description: String,
    public val flowLogId: String,
    public val flowLogName: String,
    public val id: String,
    public val logStoreName: String,
    public val projectName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetFlowlogsFlowlog): GetFlowlogsFlowlog = GetFlowlogsFlowlog(
            cenId = javaType.cenId(),
            description = javaType.description(),
            flowLogId = javaType.flowLogId(),
            flowLogName = javaType.flowLogName(),
            id = javaType.id(),
            logStoreName = javaType.logStoreName(),
            projectName = javaType.projectName(),
            status = javaType.status(),
        )
    }
}
