@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getFlowlogs.
 * @property cenId The ID of the CEN Instance.
 * @property description The description of flowlog.
 * @property flowlogs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN flow log IDs.
 * @property logStoreName The name of the log store which is in the  `project_name` SLS project.
 * @property nameRegex
 * @property names A list of CEN flow log names.
 * @property outputFile
 * @property projectName The name of the SLS project.
 * @property status The status of flowlog.
 */
public data class GetFlowlogsResult(
    public val cenId: String? = null,
    public val description: String? = null,
    public val flowlogs: List<GetFlowlogsFlowlog>,
    public val id: String,
    public val ids: List<String>,
    public val logStoreName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val projectName: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetFlowlogsResult): GetFlowlogsResult = GetFlowlogsResult(
            cenId = javaType.cenId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            flowlogs = javaType.flowlogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetFlowlogsFlowlog.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            logStoreName = javaType.logStoreName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            projectName = javaType.projectName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
