@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property childInstanceAttachTime The time when the network is associated with the CEN instance.
 * @property childInstanceId The ID of the network.
 * @property childInstanceOwnerId The ID of the account to which the network belongs.
 * @property childInstanceRegionId The region to which the network to be queried belongs.
 * @property childInstanceType The type of the associated network. Valid values: `VPC`, `VBR` and `CCN`.
 * @property id The ID of the CEN Instance Attachment.
 * @property instanceId The ID of the CEN instance.
 * @property status The status of the Cen Child Instance Attachment. Valid value: `Attaching`, `Attached` and `Aetaching`.
 */
public data class GetInstanceAttachmentsAttachment(
    public val childInstanceAttachTime: String,
    public val childInstanceId: String,
    public val childInstanceOwnerId: Int,
    public val childInstanceRegionId: String,
    public val childInstanceType: String,
    public val id: String,
    public val instanceId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInstanceAttachmentsAttachment): GetInstanceAttachmentsAttachment = GetInstanceAttachmentsAttachment(
            childInstanceAttachTime = javaType.childInstanceAttachTime(),
            childInstanceId = javaType.childInstanceId(),
            childInstanceOwnerId = javaType.childInstanceOwnerId(),
            childInstanceRegionId = javaType.childInstanceRegionId(),
            childInstanceType = javaType.childInstanceType(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            status = javaType.status(),
        )
    }
}
