@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceAttachments.
 * @property attachments A list of CEN Instance Attachments. Each element contains the following attributes:
 * @property childInstanceRegionId The ID of the region to which the network belongs.
 * @property childInstanceType The type of the associated network.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of CEN Instance Attachment IDs.
 * @property instanceId The ID of the CEN instance.
 * @property outputFile
 * @property status The status of the network.
 */
public data class GetInstanceAttachmentsResult(
    public val attachments: List<GetInstanceAttachmentsAttachment>,
    public val childInstanceRegionId: String? = null,
    public val childInstanceType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInstanceAttachmentsResult): GetInstanceAttachmentsResult = GetInstanceAttachmentsResult(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cen.kotlin.outputs.GetInstanceAttachmentsAttachment.Companion.toKotlin(args0)
                })
            }),
            childInstanceRegionId = javaType.childInstanceRegionId().map({ args0 -> args0 }).orElse(null),
            childInstanceType = javaType.childInstanceType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
