@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property cenBandwidthPackageIds List of CEN Bandwidth Package IDs in the specified CEN instance.
 * @property cenId ID of the CEN instance.
 * @property cenInstanceName Name of the CEN instance.
 * @property createTime The creation time of the CEN Instance.
 * @property description Description of the CEN instance.
 * @property id ID of the CEN instance.
 * @property name Name of the CEN instance.
 * @property protectionLevel Indicates the allowed level of CIDR block overlapping.
 * @property status The status of CEN instance. Valid value: `Active`, `Creating` and `Deleting`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetInstancesInstance(
    public val cenBandwidthPackageIds: List<String>,
    public val cenId: String,
    public val cenInstanceName: String,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val protectionLevel: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            cenBandwidthPackageIds = javaType.cenBandwidthPackageIds().map({ args0 -> args0 }),
            cenId = javaType.cenId(),
            cenInstanceName = javaType.cenInstanceName(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            protectionLevel = javaType.protectionLevel(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
