@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cen.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Inter Region Traffic Qos Policy.
 * @property interRegionTrafficQosPolicyDescription The description of the Inter Region Traffic Qos Policy.
 * @property interRegionTrafficQosPolicyId The ID of the Inter Region Traffic Qos Policy.
 * @property interRegionTrafficQosPolicyName The name of the Inter Region Traffic Qos Policy.
 * @property status The status of the traffic scheduling policy. Valid Value: `Creating`, `Active`, `Modifying`, `Deleting`, `Deleted`.
 * @property transitRouterAttachmentId The ID of the inter-region connection.
 * @property transitRouterId The ID of the transit router.
 */
public data class GetInterRegionTrafficQosPoliciesPolicy(
    public val id: String,
    public val interRegionTrafficQosPolicyDescription: String,
    public val interRegionTrafficQosPolicyId: String,
    public val interRegionTrafficQosPolicyName: String,
    public val status: String,
    public val transitRouterAttachmentId: String,
    public val transitRouterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cen.outputs.GetInterRegionTrafficQosPoliciesPolicy): GetInterRegionTrafficQosPoliciesPolicy = GetInterRegionTrafficQosPoliciesPolicy(
            id = javaType.id(),
            interRegionTrafficQosPolicyDescription = javaType.interRegionTrafficQosPolicyDescription(),
            interRegionTrafficQosPolicyId = javaType.interRegionTrafficQosPolicyId(),
            interRegionTrafficQosPolicyName = javaType.interRegionTrafficQosPolicyName(),
            status = javaType.status(),
            transitRouterAttachmentId = javaType.transitRouterAttachmentId(),
            transitRouterId = javaType.transitRouterId(),
        )
    }
}
